/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.netty.uds;

import com.flipkart.phantom.netty.uds.OioAcceptedSocketChannel;
import com.flipkart.phantom.netty.uds.OioServerSocketChannel;
import com.flipkart.phantom.netty.uds.OioServerSocketChannelFactory;
import com.flipkart.phantom.netty.uds.OioSocketChannel;
import com.flipkart.phantom.netty.uds.OioWorker;
import java.io.File;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketException;

class OioServerSocketPipelineSink
extends AbstractChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketPipelineSink.class);
    final Executor workerExecutor;
    private File socketFile;
    private Boss bossInstance;

    OioServerSocketPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof OioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof OioAcceptedSocketChannel) {
            this.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        OioServerSocketChannel channel = (OioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                this.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                this.close(channel, future);
            }
        }
    }

    private void handleAcceptedSocket(ChannelEvent e) {
        block9: {
            block8: {
                if (!(e instanceof ChannelStateEvent)) break block8;
                ChannelStateEvent event = (ChannelStateEvent)e;
                OioAcceptedSocketChannel channel = (OioAcceptedSocketChannel)event.getChannel();
                ChannelFuture future = event.getFuture();
                ChannelState state = event.getState();
                Object value = event.getValue();
                switch (state) {
                    case OPEN: {
                        if (Boolean.FALSE.equals(value)) {
                            OioWorker.close(channel, future);
                            break;
                        }
                        break block9;
                    }
                    case BOUND: 
                    case CONNECTED: {
                        if (value == null) {
                            OioWorker.close(channel, future);
                            break;
                        }
                        break block9;
                    }
                    case INTEREST_OPS: {
                        OioWorker.setInterestOps(channel, future, (Integer)value);
                    }
                }
                break block9;
            }
            if (e instanceof MessageEvent) {
                MessageEvent event = (MessageEvent)e;
                OioSocketChannel channel = (OioSocketChannel)event.getChannel();
                ChannelFuture future = event.getFuture();
                Object message = event.getMessage();
                OioWorker.write(channel, future, message);
            }
        }
    }

    private void bind(OioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            try {
                channel.socket.bind(localAddress, channel.getConfig().getBacklog());
                bound = true;
                future.setSuccess();
                localAddress = channel.getLocalAddress();
                Channels.fireChannelBound((Channel)channel, (SocketAddress)localAddress);
                Executor bossExecutor = ((OioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
                this.bossInstance = new Boss(channel);
                DeadLockProofWorker.start((Executor)bossExecutor, (Runnable)new ThreadRenamingRunnable((Runnable)this.bossInstance, "Old I/O server boss (" + (Object)((Object)channel) + ')'));
                bossStarted = true;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
                if (!bossStarted && bound) {
                    this.close(channel, future);
                }
            }
        }
        finally {
            if (!bossStarted && bound) {
                this.close(channel, future);
            }
        }
    }

    private void close(OioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            this.bossInstance.stop();
            AFUNIXSocket sock = AFUNIXSocket.newInstance();
            try {
                sock.connect((SocketAddress)new AFUNIXSocketAddress(this.socketFile));
            }
            catch (AFUNIXSocketException e) {
                logger.warn("Failed to connect to Socket while sending a stop request.");
            }
            channel.socket.close();
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound((Channel)channel);
                    }
                    Channels.fireChannelClosed((Channel)channel);
                } else {
                    future.setSuccess();
                }
            }
            finally {
                channel.shutdownLock.unlock();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught((Channel)channel, (Throwable)t);
        }
    }

    public File getSocketFile() {
        return this.socketFile;
    }

    public void setSocketFile(File socketFile) {
        this.socketFile = socketFile;
    }

    private final class Boss
    implements Runnable {
        private final OioServerSocketChannel channel;
        private boolean isAlive = true;

        Boss(OioServerSocketChannel channel) {
            this.channel = channel;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void stop() {
            this.isAlive = false;
        }
    }
}

