/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.thrift;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.runtime.impl.server.netty.channel.thrift.ThriftNettyChannelBuffer;
import com.flipkart.phantom.task.impl.collector.EventDispatchingSpanCollector;
import com.flipkart.phantom.task.impl.interceptor.ServerRequestInterceptor;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestContext;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import com.flipkart.phantom.thrift.impl.ThriftProxy;
import com.flipkart.phantom.thrift.impl.ThriftRequestWrapper;
import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.FixedSampleRateTraceFilter;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.TraceFilter;
import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ThriftChannelHandler
extends SimpleChannelUpstreamHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftChannelHandler.class);
    private static final String DEFAULT_SERVICE_NAME = "Thrift Proxy";
    private static final String THRIFT_HANDLER = "THRIFT_HANDLER";
    private static final int DEFAULT_RESPONSE_SIZE = 4096;
    private static final TraceFilter NO_TRACING = new FixedSampleRateTraceFilter(-1);
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    private static String hostName = "localhost";
    private String serviceName = "Thrift Proxy";
    private int hostPort;
    private ChannelGroup defaultChannelGroup;
    private ExecutorRepository<ThriftRequestWrapper, TTransport, ThriftProxy> repository;
    private String thriftProxy;
    private int responseSize = 4096;
    private TProtocolFactory protocolFactory = new TBinaryProtocol.Factory();
    private ServiceProxyEventProducer eventProducer;
    private TraceFilter traceFilter = NO_TRACING;
    private EventDispatchingSpanCollector eventDispatchingSpanCollector;

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to resolve local host name. Will use default host name : localhost");
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.defaultChannelGroup, (String)"The 'defaultChannelGroup' may not be null");
        Assert.notNull(this.repository, (String)"The 'repository' may not be null");
        Assert.notNull((Object)this.thriftProxy, (String)"The 'thriftProxy' may not be null");
        Assert.notNull((Object)this.eventProducer, (String)"The 'eventProducer' may not be null");
        Assert.notNull((Object)this.eventDispatchingSpanCollector, (String)"The 'eventDispatchingSpanCollector' may not be null");
    }

    public void channelBound(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelBound(ctx, event);
        if (InetSocketAddress.class.isAssignableFrom(event.getValue().getClass())) {
            this.hostPort = ((InetSocketAddress)event.getValue()).getPort();
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
        this.defaultChannelGroup.add((Object)event.getChannel());
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        long receiveTime = System.currentTimeMillis();
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            ChannelBuffer input = (ChannelBuffer)((MessageEvent)event).getMessage();
            ChannelBuffer output = ChannelBuffers.dynamicBuffer((int)this.responseSize);
            ThriftNettyChannelBuffer clientTransport = new ThriftNettyChannelBuffer(input, output);
            ThriftNettyChannelBuffer ttransport = new ThriftNettyChannelBuffer(input, null);
            TProtocol iprot = this.protocolFactory.getProtocol((TTransport)ttransport);
            input.markReaderIndex();
            TMessage message = iprot.readMessageBegin();
            input.resetReaderIndex();
            ThriftRequestWrapper thriftRequestWrapper = new ThriftRequestWrapper();
            thriftRequestWrapper.setClientSocket((TTransport)clientTransport);
            thriftRequestWrapper.setMethodName(message.name);
            thriftRequestWrapper.setServiceName(Optional.of((Object)this.serviceName));
            ServerRequestInterceptor<ThriftRequestWrapper, TTransport> serverRequestInterceptor = this.initializeServerTracing(thriftRequestWrapper);
            Executor executor = this.repository.getExecutor(message.name, this.thriftProxy, (RequestWrapper)thriftRequestWrapper);
            thriftRequestWrapper.setServiceName(executor.getServiceName());
            Optional transportError = Optional.absent();
            try {
                try {
                    executor.execute();
                }
                catch (Exception e) {
                    RuntimeException runtimeException = new RuntimeException("Error in executing Thrift request: " + this.thriftProxy + ":" + message.name, e);
                    transportError = Optional.of((Object)runtimeException);
                    throw runtimeException;
                }
            }
            finally {
                serverRequestInterceptor.process((Object)clientTransport, transportError);
                if (this.eventProducer != null) {
                    ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(String.valueOf(this.thriftProxy) + ":" + message.name, THRIFT_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData(executor).withEventSource(executor.getClass().getName());
                    eventBuilder.withRequestReceiveTime(receiveTime);
                    this.eventProducer.publishEvent(eventBuilder.build());
                } else {
                    LOGGER.debug("eventProducer not set, not publishing event");
                }
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)event.getFuture(), (Object)clientTransport.getOutputBuffer());
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
        super.exceptionCaught(ctx, event);
    }

    private ServerRequestInterceptor<ThriftRequestWrapper, TTransport> initializeServerTracing(ThriftRequestWrapper executorRequest) {
        ServerRequestInterceptor serverRequestInterceptor = new ServerRequestInterceptor();
        List<TraceFilter> traceFilters = Arrays.asList(this.traceFilter);
        ServerTracer serverTracer = Brave.getServerTracer((SpanCollector)this.eventDispatchingSpanCollector, traceFilters);
        serverRequestInterceptor.setEndPointSubmitter(Brave.getEndPointSubmitter());
        serverRequestInterceptor.setServerTracer(serverTracer);
        serverRequestInterceptor.setServiceHost(hostName);
        serverRequestInterceptor.setServicePort(this.hostPort);
        serverRequestInterceptor.setServiceName(this.serviceName);
        serverRequestInterceptor.process((RequestWrapper)executorRequest);
        ServerSpan serverSpan = Brave.getServerSpanThreadBinder().getCurrentServerSpan();
        RequestContext serverRequestContext = new RequestContext();
        serverRequestContext.setCurrentServerSpan(serverSpan);
        executorRequest.setRequestContext(Optional.of((Object)serverRequestContext));
        return serverRequestInterceptor;
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public ExecutorRepository<ThriftRequestWrapper, TTransport, ThriftProxy> getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository<ThriftRequestWrapper, TTransport, ThriftProxy> repository) {
        this.repository = repository;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public String getThriftProxy() {
        return this.thriftProxy;
    }

    public void setThriftProxy(String thriftProxy) {
        this.thriftProxy = thriftProxy;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    public void setTraceFilter(TraceFilter traceFilter) {
        this.traceFilter = traceFilter;
    }

    public void setEventDispatchingSpanCollector(EventDispatchingSpanCollector eventDispatchingSpanCollector) {
        this.eventDispatchingSpanCollector = eventDispatchingSpanCollector;
    }
}

