/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.thrift;

import com.flipkart.phantom.runtime.impl.server.netty.channel.thrift.ThriftNettyChannelBuffer;
import com.flipkart.phantom.task.utils.RequestLogger;
import com.flipkart.phantom.thrift.impl.ThriftProxyExecutor;
import com.flipkart.phantom.thrift.impl.ThriftProxyExecutorRepository;
import com.netflix.hystrix.HystrixCommand;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final int DEFAULT_RESPONSE_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftChannelHandler.class);
    private ThriftProxyExecutorRepository repository;
    private String thriftProxy;
    private int responseSize = 4096;
    private TProtocolFactory protocolFactory = new TBinaryProtocol.Factory();

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent event) throws Exception {
        if (MessageEvent.class.isAssignableFrom(event.getClass())) {
            ChannelBuffer input = (ChannelBuffer)((MessageEvent)event).getMessage();
            ChannelBuffer output = ChannelBuffers.dynamicBuffer((int)this.responseSize);
            ThriftNettyChannelBuffer clientTransport = new ThriftNettyChannelBuffer(input, output);
            ThriftNettyChannelBuffer ttransport = new ThriftNettyChannelBuffer(input, null);
            TProtocol iprot = this.protocolFactory.getProtocol((TTransport)ttransport);
            input.markReaderIndex();
            TMessage message = iprot.readMessageBegin();
            input.resetReaderIndex();
            ThriftProxyExecutor executor = this.repository.getThriftProxyExecutor(this.thriftProxy, message.name);
            executor.setClientTransport((TTransport)clientTransport);
            try {
                executor.execute();
            }
            catch (Exception e) {
                LOGGER.error("Error in executing Thrift request: " + this.thriftProxy + ":" + message.name, (Throwable)e);
                throw new RuntimeException("Error in executing Thrift request: " + this.thriftProxy + ":" + message.name, e);
            }
            finally {
                RequestLogger.log((HystrixCommand)executor);
            }
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)event.getFuture(), (Object)clientTransport.getOutputBuffer());
        }
        super.handleUpstream(ctx, event);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getChannel().close();
        super.exceptionCaught(ctx, event);
    }

    public ThriftProxyExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ThriftProxyExecutorRepository repository) {
        this.repository = repository;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(int responseSize) {
        this.responseSize = responseSize;
    }

    public String getThriftProxy() {
        return this.thriftProxy;
    }

    public void setThriftProxy(String thriftProxy) {
        this.thriftProxy = thriftProxy;
    }
}

