/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.http;

import com.flipkart.phantom.event.ServiceProxyEvent;
import com.flipkart.phantom.event.ServiceProxyEventProducer;
import com.flipkart.phantom.http.impl.HttpRequestWrapper;
import com.flipkart.phantom.task.spi.Executor;
import com.flipkart.phantom.task.spi.RequestWrapper;
import com.flipkart.phantom.task.spi.repository.ExecutorRepository;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class RoutingHttpChannelHandler
extends SimpleChannelUpstreamHandler
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingHttpChannelHandler.class);
    public static final String ALL_ROUTES = "";
    public static final Set<String> REMOVE_HEADERS = new HashSet<String>();
    private ChannelGroup defaultChannelGroup;
    private ExecutorRepository repository;
    private Map<String, String> proxyMap = new HashMap<String, String>();
    private String defaultProxy;
    private ServiceProxyEventProducer eventProducer;
    private static final String HTTP_HANDLER = "HTTP_HANDLER";

    static {
        REMOVE_HEADERS.add("Transfer-Encoding");
        REMOVE_HEADERS.add("Connection");
        REMOVE_HEADERS.add("Keep-Alive");
        REMOVE_HEADERS.add("Host");
        REMOVE_HEADERS.add("Proxy-Authenticate");
        REMOVE_HEADERS.add("TE");
        REMOVE_HEADERS.add("Trailers");
        REMOVE_HEADERS.add("Upgrade");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.defaultProxy, (String)"The 'defaultProxy' may not be null");
        this.proxyMap.put(ALL_ROUTES, this.defaultProxy);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        long receiveTime = System.currentTimeMillis();
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        LOGGER.debug("Request is: " + request.getMethod() + " " + request.getUri());
        this.processRequestHeaders(request);
        ChannelBuffer inputBuffer = request.getContent();
        byte[] requestData = new byte[inputBuffer.readableBytes()];
        inputBuffer.readBytes(requestData, 0, requestData.length);
        HttpRequestWrapper executorHttpRequest = new HttpRequestWrapper();
        executorHttpRequest.setData(requestData);
        executorHttpRequest.setMethod(request.getMethod().toString());
        executorHttpRequest.setUri(request.getUri());
        executorHttpRequest.setHeaders(request.getHeaders());
        executorHttpRequest.setProtocol(request.getProtocolVersion().getProtocolName());
        executorHttpRequest.setMajorVersion(request.getProtocolVersion().getMajorVersion());
        executorHttpRequest.setMinorVersion(request.getProtocolVersion().getMinorVersion());
        String proxy = this.proxyMap.get(this.getRoutingKey(request));
        if (proxy == null) {
            proxy = this.proxyMap.get(ALL_ROUTES);
            LOGGER.info("Routing key for : " + request.getUri() + " returned null. Using default proxy instead.");
        }
        Executor executor = this.repository.getExecutor(proxy, proxy, (RequestWrapper)executorHttpRequest);
        HttpResponse response = null;
        try {
            try {
                response = (HttpResponse)executor.execute();
            }
            catch (Exception e) {
                throw new RuntimeException("Error in executing HTTP request:" + proxy + " URI:" + request.getUri(), e);
            }
        }
        finally {
            if (this.eventProducer != null) {
                ServiceProxyEvent.Builder eventBuilder = executor == null ? new ServiceProxyEvent.Builder(request.getUri(), HTTP_HANDLER).withEventSource(((Object)((Object)this)).getClass().getName()) : executor.getEventBuilder().withCommandData(executor).withEventSource(executor.getClass().getName());
                eventBuilder.withRequestReceiveTime(receiveTime);
                this.eventProducer.publishEvent(eventBuilder.build());
            } else {
                LOGGER.debug("eventProducer not set, not publishing event");
            }
        }
        this.writeCommandExecutionResponse(ctx, (ChannelEvent)messageEvent, response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getCause().printStackTrace();
        event.getChannel().close();
    }

    protected abstract String getRoutingKey(HttpRequest var1);

    private void writeCommandExecutionResponse(ChannelHandlerContext ctx, ChannelEvent event, HttpResponse response) throws Exception {
        if (response == null) {
            event.getChannel().write((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT)).addListener(ChannelFutureListener.CLOSE);
            return;
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.getStatusLine().getStatusCode()));
        Header[] headerArray = response.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            if (!REMOVE_HEADERS.contains(header.getName())) {
                httpResponse.setHeader(header.getName(), (Object)header.getValue());
            }
            ++n2;
        }
        HttpEntity responseEntity = response.getEntity();
        byte[] responseData = EntityUtils.toByteArray((HttpEntity)responseEntity);
        httpResponse.setContent(ChannelBuffers.copiedBuffer((byte[])responseData));
        event.getChannel().write((Object)httpResponse).addListener(ChannelFutureListener.CLOSE);
    }

    protected void processRequestHeaders(HttpRequest request) {
        for (String header : REMOVE_HEADERS) {
            request.removeHeader(header);
        }
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public ExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ExecutorRepository repository) {
        this.repository = repository;
    }

    public Map<String, String> getProxyMap() {
        return this.proxyMap;
    }

    public void setProxyMap(Map<String, String> proxyMap) {
        this.proxyMap = proxyMap;
    }

    public String getDefaultProxy() {
        return this.defaultProxy;
    }

    public void setDefaultProxy(String defaultProxy) {
        this.defaultProxy = defaultProxy;
    }

    public void setEventProducer(ServiceProxyEventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

