/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.phantom.runtime.impl.server.netty.handler.http;

import com.flipkart.phantom.http.impl.HttpProxyExecutor;
import com.flipkart.phantom.http.impl.HttpProxyExecutorRepository;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class RoutingHttpChannelHandler
extends SimpleChannelUpstreamHandler
implements InitializingBean {
    public static final String ALL_ROUTES = "";
    private static final String ENCODING_HEADER = "Transfer-Encoding";
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingHttpChannelHandler.class);
    private ChannelGroup defaultChannelGroup;
    private HttpProxyExecutorRepository repository;
    private Map<String, String> proxyMap = new HashMap<String, String>();
    private String defaultProxy;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.defaultProxy, (String)"The 'defaultProxy' may not be null");
        this.proxyMap.put(ALL_ROUTES, this.defaultProxy);
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
        super.channelOpen(ctx, event);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        LOGGER.debug("Request is: " + request.getMethod() + " " + request.getUri());
        ChannelBuffer inputBuffer = request.getContent();
        byte[] requestData = new byte[inputBuffer.readableBytes()];
        inputBuffer.readBytes(requestData, 0, requestData.length);
        String proxy = this.proxyMap.get(this.getRoutingKey(request));
        if (proxy == null) {
            proxy = this.proxyMap.get(ALL_ROUTES);
            LOGGER.info("Routing key for : " + request.getUri() + " returned null. Using default proxy instead.");
        }
        HttpProxyExecutor executor = this.repository.getHttpProxyExecutor(proxy, request.getMethod().toString(), request.getUri(), requestData);
        HttpResponse response = (HttpResponse)executor.execute();
        this.writeCommandExecutionResponse(ctx, (ChannelEvent)messageEvent, response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        LOGGER.warn("Exception {} thrown on Channel {}. Disconnect initiated", (Object)event, (Object)event.getChannel());
        event.getCause().printStackTrace();
        event.getChannel().close();
    }

    protected abstract String getRoutingKey(HttpRequest var1);

    private void writeCommandExecutionResponse(ChannelHandlerContext ctx, ChannelEvent event, HttpResponse response) throws Exception {
        if (response == null) {
            return;
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.getStatusLine().getStatusCode()));
        for (Header header : response.getAllHeaders()) {
            if (header.getName().equals(ENCODING_HEADER)) continue;
            httpResponse.setHeader(header.getName(), (Object)header.getValue());
        }
        HttpEntity responseEntity = response.getEntity();
        byte[] responseData = EntityUtils.toByteArray((HttpEntity)responseEntity);
        httpResponse.setContent(ChannelBuffers.copiedBuffer((byte[])responseData));
        event.getChannel().write((Object)httpResponse).addListener(ChannelFutureListener.CLOSE);
    }

    public ChannelGroup getDefaultChannelGroup() {
        return this.defaultChannelGroup;
    }

    public void setDefaultChannelGroup(ChannelGroup defaultChannelGroup) {
        this.defaultChannelGroup = defaultChannelGroup;
    }

    public HttpProxyExecutorRepository getRepository() {
        return this.repository;
    }

    public void setRepository(HttpProxyExecutorRepository repository) {
        this.repository = repository;
    }

    public Map<String, String> getProxyMap() {
        return this.proxyMap;
    }

    public void setProxyMap(Map<String, String> proxyMap) {
        this.proxyMap = proxyMap;
    }

    public String getDefaultProxy() {
        return this.defaultProxy;
    }

    public void setDefaultProxy(String defaultProxy) {
        this.defaultProxy = defaultProxy;
    }
}

