/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ResultSetFieldPacket
extends AbstractPacket {
    private static final long serialVersionUID = -6484191963940716299L;
    private StringColumn catalog;
    private StringColumn db;
    private StringColumn table;
    private StringColumn orginalTable;
    private StringColumn column;
    private StringColumn originalColumn;
    private int fixed12;
    private int charset;
    private long fieldLength;
    private int fieldType;
    private int fieldOptions;
    private int decimalPrecision;
    private int reserved;
    private StringColumn defaultValue;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("catalog", (Object)this.catalog).append("db", (Object)this.db).append("table", (Object)this.table).append("orginalTable", (Object)this.orginalTable).append("column", (Object)this.column).append("originalColumn", (Object)this.originalColumn).append("fixed12", this.fixed12).append("charset", this.charset).append("fieldLength", this.fieldLength).append("fieldType", this.fieldType).append("fieldOptions", this.fieldOptions).append("decimalPrecision", this.decimalPrecision).append("reserved", this.reserved).append("defaultValue", (Object)this.defaultValue).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(256);
        s.writeLengthCodedString(this.catalog);
        s.writeLengthCodedString(this.db);
        s.writeLengthCodedString(this.table);
        s.writeLengthCodedString(this.orginalTable);
        s.writeLengthCodedString(this.column);
        s.writeLengthCodedString(this.originalColumn);
        s.writeInt(this.fixed12, 1);
        s.writeInt(this.charset, 2);
        s.writeLong(this.fieldLength, 4);
        s.writeInt(this.fieldType, 1);
        s.writeInt(this.fieldOptions, 2);
        s.writeInt(this.decimalPrecision, 1);
        s.writeInt(this.reserved, 2);
        if (this.defaultValue != null) {
            s.writeLengthCodedString(this.defaultValue);
        }
        return s.toByteArray();
    }

    public StringColumn getCatalog() {
        return this.catalog;
    }

    public void setCatalog(StringColumn catalog) {
        this.catalog = catalog;
    }

    public StringColumn getDb() {
        return this.db;
    }

    public void setDb(StringColumn db) {
        this.db = db;
    }

    public StringColumn getTable() {
        return this.table;
    }

    public void setTable(StringColumn table) {
        this.table = table;
    }

    public StringColumn getOrginalTable() {
        return this.orginalTable;
    }

    public void setOrginalTable(StringColumn orginalTable) {
        this.orginalTable = orginalTable;
    }

    public StringColumn getColumn() {
        return this.column;
    }

    public void setColumn(StringColumn column) {
        this.column = column;
    }

    public StringColumn getOriginalColumn() {
        return this.originalColumn;
    }

    public void setOriginalColumn(StringColumn originalColumn) {
        this.originalColumn = originalColumn;
    }

    public int getFixed12() {
        return this.fixed12;
    }

    public void setFixed12(int fixed12) {
        this.fixed12 = fixed12;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public long getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(long fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int fieldType) {
        this.fieldType = fieldType;
    }

    public int getFieldOptions() {
        return this.fieldOptions;
    }

    public void setFieldOptions(int fieldOptions) {
        this.fieldOptions = fieldOptions;
    }

    public int getDecimalPrecision() {
        return this.decimalPrecision;
    }

    public void setDecimalPrecision(int decimalPrecision) {
        this.decimalPrecision = decimalPrecision;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public StringColumn getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(StringColumn defaultValue) {
        this.defaultValue = defaultValue;
    }

    public static ResultSetFieldPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        ResultSetFieldPacket r = new ResultSetFieldPacket();
        r.fieldLength = packet.getLength();
        r.sequence = packet.getSequence();
        r.catalog = d.readLengthCodedString();
        r.db = d.readLengthCodedString();
        r.table = d.readLengthCodedString();
        r.orginalTable = d.readLengthCodedString();
        r.column = d.readLengthCodedString();
        r.originalColumn = d.readLengthCodedString();
        r.fixed12 = d.readInt(1);
        r.charset = d.readInt(2);
        r.fieldLength = d.readLong(4);
        r.fieldType = d.readInt(1);
        r.fieldOptions = d.readInt(2);
        r.decimalPrecision = d.readInt(1);
        r.reserved = d.readInt(2);
        if (d.available() > 0) {
            r.defaultValue = d.readLengthCodedString();
        }
        return r;
    }
}

