/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.net.impl.packet;

import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.io.util.XDeserializer;
import com.google.code.or.io.util.XSerializer;
import com.google.code.or.net.Packet;
import com.google.code.or.net.impl.packet.AbstractPacket;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class GreetingPacket
extends AbstractPacket {
    private static final long serialVersionUID = 5506239117316020734L;
    private int protocolVersion;
    private StringColumn serverVersion;
    private long threadId;
    private StringColumn scramble1;
    private int serverCapabilities;
    private int serverCollation;
    private int serverStatus;
    private StringColumn scramble2;
    private StringColumn pluginProvidedData;

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("protocolVersion", this.protocolVersion).append("serverVersion", (Object)this.serverVersion).append("threadId", this.threadId).append("scramble1", (Object)this.scramble1).append("serverCapabilities", this.serverCapabilities).append("serverCollation", this.serverCollation).append("serverStatus", this.serverStatus).append("scramble2", (Object)this.scramble2).append("pluginProvidedData", (Object)this.pluginProvidedData).toString();
    }

    public byte[] getPacketBody() {
        XSerializer s = new XSerializer(128);
        s.writeInt(this.protocolVersion, 1);
        s.writeNullTerminatedString(this.serverVersion);
        s.writeLong(this.threadId, 4);
        s.writeNullTerminatedString(this.scramble1);
        s.writeInt(this.serverCapabilities, 2);
        s.writeInt(this.serverCollation, 1);
        s.writeInt(this.serverStatus, 2);
        s.writeInt(0, 13);
        s.writeNullTerminatedString(this.scramble2);
        s.writeNullTerminatedString(this.pluginProvidedData);
        return s.toByteArray();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public StringColumn getServerVersion() {
        return this.serverVersion;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public StringColumn getScramble1() {
        return this.scramble1;
    }

    public int getServerCapabilities() {
        return this.serverCapabilities;
    }

    public int getServerCollation() {
        return this.serverCollation;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public StringColumn getScramble2() {
        return this.scramble2;
    }

    public static GreetingPacket valueOf(Packet packet) throws IOException {
        XDeserializer d = new XDeserializer(packet.getPacketBody());
        GreetingPacket r = new GreetingPacket();
        r.length = packet.getLength();
        r.sequence = packet.getSequence();
        r.protocolVersion = d.readInt(1);
        r.serverVersion = d.readNullTerminatedString();
        r.threadId = d.readLong(4);
        r.scramble1 = d.readNullTerminatedString();
        r.serverCapabilities = d.readInt(2);
        r.serverCollation = d.readInt(1);
        r.serverStatus = d.readInt(2);
        d.skip(13L);
        r.scramble2 = d.readNullTerminatedString();
        if (d.hasMore()) {
            r.pluginProvidedData = d.readNullTerminatedString();
        }
        return r;
    }
}

