/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.io.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RamdomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile file;

    public RamdomAccessFileInputStream(File file) throws IOException {
        this.file = new RandomAccessFile(file, "r");
    }

    public int available() throws IOException {
        long fp = this.file.getFilePointer();
        return (int)(this.file.length() - fp);
    }

    public void close() throws IOException {
        this.file.close();
    }

    public long skip(long n) throws IOException {
        long fp = this.file.getFilePointer();
        this.file.seek(fp + n);
        return n;
    }

    public int read() throws IOException {
        return this.file.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.file.read(b, off, len);
    }
}

