/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.util;

import com.google.code.or.common.util.CodecUtils;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public final class MySQLUtils {
    private static final int DIGITS_PER_4BYTES = 9;
    private static final BigDecimal POSITIVE_ONE = BigDecimal.ONE;
    private static final BigDecimal NEGATIVE_ONE = new BigDecimal("-1");
    private static final int[] DECIMAL_BINARY_SIZE = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4};

    public static byte[] password41OrLater(byte[] password, byte[] scramble) {
        byte[] stage1 = CodecUtils.sha(password);
        byte[] stage2 = CodecUtils.sha(CodecUtils.concat(scramble, CodecUtils.sha(stage1)));
        return CodecUtils.xor(stage1, stage2);
    }

    public static int toYear(int value) {
        return 1900 + value;
    }

    public static java.sql.Date toDate(int value) {
        int d = value % 32;
        int m = (value >>>= 5) % 16;
        int y = value >> 4;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(y, m - 1, d);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Time toTime(int value) {
        int s = value % 100;
        int m = (value /= 100) % 100;
        int h = value / 100;
        Calendar c = Calendar.getInstance();
        c.set(70, 0, 1, h, m, s);
        return new Time(c.getTimeInMillis());
    }

    public static Time toTime(long tval, int fsp, int fspLen) {
        tval = tval - 0x800000L & 0xBFFFFFL;
        Time time = Time.valueOf((int)(tval >> 12) + ":" + (int)(tval >> 6 & 0x3FL) + ":" + (int)(tval & 0x3FL));
        return time;
    }

    public static Date toDatetime(long value) {
        int sec = (int)(value % 100L);
        int min = (int)((value /= 100L) % 100L);
        int hour = (int)((value /= 100L) % 100L);
        int day = (int)((value /= 100L) % 100L);
        int mon = (int)((value /= 100L) % 100L);
        int year = (int)(value / 100L);
        Calendar c = Calendar.getInstance();
        c.set(year, mon - 1, day, hour, min, sec);
        return c.getTime();
    }

    public static Date toDatetime(long value, int fsp, int fspLen) {
        value = value - 0x8000000000L & 0xFFFFFFFFFFL;
        Calendar c = Calendar.getInstance();
        c.set((int)((value >> 22) / 13L), (int)((value >> 22) % 13L) - 1, (int)(value >> 17 & 0x1FL), (int)(value >> 12 & 0x1FL), (int)(value >> 6 & 0x3FL), (int)(value & 0x3FL));
        return c.getTime();
    }

    public static Timestamp toTimestamp(long value) {
        return new Timestamp(value * 1000L);
    }

    public static BigDecimal toDecimal(int precision, int scale, byte[] value) {
        int i;
        BigDecimal ip;
        boolean positive = (value[0] & 0x80) == 128;
        value[0] = (byte)(value[0] ^ 0x80);
        if (!positive) {
            int i2 = 0;
            while (i2 < value.length) {
                int n = i2++;
                value[n] = (byte)(value[n] ^ 0xFF);
            }
        }
        int x = precision - scale;
        int ipDigits = x / 9;
        int ipDigitsX = x - ipDigits * 9;
        int ipSize = (ipDigits << 2) + DECIMAL_BINARY_SIZE[ipDigitsX];
        int offset = DECIMAL_BINARY_SIZE[ipDigitsX];
        BigDecimal bigDecimal = ip = offset > 0 ? BigDecimal.valueOf(CodecUtils.toInt(value, 0, offset)) : BigDecimal.ZERO;
        while (offset < ipSize) {
            int i3 = CodecUtils.toInt(value, offset, 4);
            ip = ip.movePointRight(9).add(BigDecimal.valueOf(i3));
            offset += 4;
        }
        int shift = 0;
        BigDecimal fp = BigDecimal.ZERO;
        while (shift + 9 <= scale) {
            i = CodecUtils.toInt(value, offset, 4);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(shift + 9));
            shift += 9;
            offset += 4;
        }
        if (shift < scale) {
            i = CodecUtils.toInt(value, offset, DECIMAL_BINARY_SIZE[scale - shift]);
            fp = fp.add(BigDecimal.valueOf(i).movePointLeft(scale));
        }
        return positive ? POSITIVE_ONE.multiply(ip.add(fp)) : NEGATIVE_ONE.multiply(ip.add(fp));
    }

    public static int getDecimalBinarySize(int precision, int scale) {
        int x = precision - scale;
        int ipDigits = x / 9;
        int fpDigits = scale / 9;
        int ipDigitsX = x - ipDigits * 9;
        int fpDigitsX = scale - fpDigits * 9;
        return (ipDigits << 2) + DECIMAL_BINARY_SIZE[ipDigitsX] + (fpDigits << 2) + DECIMAL_BINARY_SIZE[fpDigitsX];
    }

    public static Timestamp toTimestamp(long value, int fsp, int fspLen) {
        Timestamp ts = MySQLUtils.toTimestamp(value);
        ts.setNanos(fsp > 0 ? MySQLUtils.convertToNanos(fsp, fspLen) : 0);
        return ts;
    }

    private static int convertToNanos(int fspVal, int fspLen) {
        return fspVal * 1000 * (int)Math.pow(10.0, (3 - fspLen) * 2);
    }
}

