/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class LongColumn
implements Column {
    private static final long serialVersionUID = -4109941053716659749L;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private static final LongColumn[] CACHE = new LongColumn[255];
    private final int value;

    private LongColumn(int value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public Integer getValue() {
        return this.value;
    }

    public static final LongColumn valueOf(int value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("invalid value: " + value);
        }
        int index = value - -128;
        return index >= 0 && index < CACHE.length ? CACHE[index] : new LongColumn(value);
    }

    static {
        for (int i = 0; i < CACHE.length; ++i) {
            LongColumn.CACHE[i] = new LongColumn(i + -128);
        }
    }
}

