/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.common.glossary.column;

import com.google.code.or.common.glossary.Column;

public final class BitColumn
implements Column {
    private static final long serialVersionUID = 4193150509864408687L;
    private static final int[] BIT_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private final int length;
    private final byte[] value;

    private BitColumn(int length, byte[] value) {
        this.length = length;
        this.value = value;
    }

    public String toString() {
        StringBuilder r = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            r.append(this.get(i) ? "1" : "0");
        }
        return r.toString();
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean get(int index) {
        int byteIndex = index >> 3;
        int bitIndex = index - (byteIndex << 3);
        return (this.value[byteIndex] & BIT_MASKS[bitIndex]) != 0;
    }

    public void set(int index) {
        int byteIndex = index >> 3;
        int bitIndex = index - (byteIndex << 3);
        int n = byteIndex;
        this.value[n] = (byte)(this.value[n] | BIT_MASKS[bitIndex]);
    }

    public static final BitColumn valueOf(int length, byte[] value) {
        if (length < 0 || length > value.length << 3) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        return new BitColumn(length, value);
    }
}

