/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.or.binlog.impl.parser;

import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.binlog.BinlogParserContext;
import com.google.code.or.binlog.UserVariable;
import com.google.code.or.binlog.impl.event.UserVarEvent;
import com.google.code.or.binlog.impl.parser.AbstractBinlogEventParser;
import com.google.code.or.binlog.impl.variable.user.UserVariableDecimal;
import com.google.code.or.binlog.impl.variable.user.UserVariableInt;
import com.google.code.or.binlog.impl.variable.user.UserVariableReal;
import com.google.code.or.binlog.impl.variable.user.UserVariableRow;
import com.google.code.or.binlog.impl.variable.user.UserVariableString;
import com.google.code.or.io.XInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserVarEventParser
extends AbstractBinlogEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserVarEventParser.class);

    public UserVarEventParser() {
        super(14);
    }

    public void parse(XInputStream is, BinlogEventV4Header header, BinlogParserContext context) throws IOException {
        UserVarEvent event = new UserVarEvent(header);
        event.setVarNameLength(is.readInt(4));
        event.setVarName(is.readFixedLengthString(event.getVarNameLength()));
        event.setIsNull(is.readInt(1));
        if (event.getIsNull() == 0) {
            event.setVarType(is.readInt(1));
            event.setVarCollation(is.readInt(4));
            event.setVarValueLength(is.readInt(4));
            event.setVarValue(this.parseUserVariable(is, event));
        }
        context.getEventListener().onEvents(event);
    }

    protected UserVariable parseUserVariable(XInputStream is, UserVarEvent event) throws IOException {
        int type = event.getVarType();
        switch (type) {
            case 4: {
                return new UserVariableDecimal(is.readBytes(event.getVarValueLength()));
            }
            case 2: {
                return new UserVariableInt(is.readLong(event.getVarValueLength()), is.readInt(1));
            }
            case 1: {
                return new UserVariableReal(Double.longBitsToDouble(is.readLong(event.getVarValueLength())));
            }
            case 3: {
                return new UserVariableRow(is.readBytes(event.getVarValueLength()));
            }
            case 0: {
                return new UserVariableString(is.readBytes(event.getVarValueLength()), event.getVarCollation());
            }
        }
        LOGGER.warn("unknown user variable type: " + type);
        return null;
    }
}

