/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.mojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.flipkart.krystal.mojo.MultiProjectInfo;
import com.flipkart.krystal.mojo.ProjectInfo;
import com.flipkart.krystal.mojo.ProjectStageInfo;
import com.flipkart.krystal.mojo.PublishStage;
import com.flipkart.krystal.mojo.PublishTarget;
import com.flipkart.krystal.mojo.PublishTask;
import com.google.common.base.Preconditions;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;

final class Publisher {
    public static final String DEFAULT_VERSION = "0.0.0";
    private final Set<Project> allProjects = new LinkedHashSet<Project>();
    private final Map<Project, Set<Project>> projectDependencies = new LinkedHashMap<Project, Set<Project>>();
    private final Map<Project, Set<Project>> projectToDependendents = new LinkedHashMap<Project, Set<Project>>();
    private final Map<Path, Project> absolutePathToProject = new LinkedHashMap<Path, Project>();
    private static final ObjectMapper OBJECT_MAPPER = new YAMLMapper(new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    private final Project rootProject;
    private @Nullable MultiProjectInfo multiProjectInfo;
    private PublishStage publishStage;
    private boolean projectScanCompleted = false;

    Publisher(Project project) {
        this.rootProject = project.getRootProject();
        this.scanAllProjects();
    }

    static boolean isPendingPublish(Project project, PublishTarget target, PublishStage ... publishStage) throws IOException {
        Optional<ProjectInfo> projectInfoOpt = Publisher.getProjectInfo(Publisher.readMultiProjectInfoOrDefault(project.getRootProject()), project, false);
        return projectInfoOpt.map(projectInfo -> Arrays.stream(publishStage).map(projectInfo::getStageInfo).filter(Optional::isPresent).map(Optional::get).filter(si -> si.getPendingTargets() != null && si.getPendingTargets().contains((Object)target)).map(projectStageInfo -> true).findAny().orElse(false)).orElse(false);
    }

    static boolean isPendingPublish(Project project, PublishTarget repository) throws IOException {
        return Publisher.isPendingPublish(project, repository, PublishStage.values());
    }

    void printMojoState(Project project) throws IOException, GitAPIException {
        Logger l = project.getLogger();
        MultiProjectInfo multiProjectInfo = Publisher.readMultiProjectInfoOrDefault(project);
        l.lifecycle("------------------------------------------------------------------------------------------");
        try (Git git = Git.open((File)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.rootProject.getRootDir())).getGitDir());){
            Repository repo = git.getRepository();
            ObjectId headCommit = repo.resolve("HEAD");
            String baseCommitId = multiProjectInfo.getBaseCommitId();
            l.lifecycle("HEAD commit id: {}", new Object[]{headCommit.name()});
            l.lifecycle("Base commit id: {}", new Object[]{baseCommitId});
            l.lifecycle("------------------------------------------------------------------------------------------");
            l.lifecycle("Diff:");
            LogCommand log = git.log();
            if (baseCommitId != null) {
                log.addRange((AnyObjectId)repo.resolve(baseCommitId), (AnyObjectId)headCommit);
            }
            for (RevCommit revCommit : log.call()) {
                l.lifecycle("{} - {}", new Object[]{revCommit.getId().abbreviate(7).name(), revCommit.getShortMessage()});
            }
        }
        l.lifecycle("------------------------------------------------------------------------------------------");
        l.lifecycle("%20s | %-15s | %s".formatted("Project Name", "Production", "Development"));
        l.lifecycle("------------------------------------------------------------------------------------------");
        this.getCurrentProjectVersions(project, multiProjectInfo).forEach((p, versionMap) -> l.lifecycle("%20s : %-15s | %s".formatted(p.getName(), versionMap.get((Object)PublishStage.PRODUCTION), versionMap.get((Object)PublishStage.DEV))));
        l.lifecycle("------------------------------------------------------------------------------------------");
        l.lifecycle("L = Pending Local Publish, R = Pending Remote Publish");
        l.lifecycle("------------------------------------------------------------------------------------------");
    }

    String getMojoVersion(Project project) throws IOException {
        Optional<ProjectInfo> projectInfo = Publisher.getProjectInfo(this.getMultiProjectInfo(), project, false);
        if (projectInfo.isEmpty()) {
            return null;
        }
        return Publisher.getCurrentProjectVersion(project, this.getPublishStage(projectInfo.get()), this.getMultiProjectInfo()).version().getValue();
    }

    void mojoProjectVersions(PublishTask publishTask, PublishStage publishStage) throws IOException, GitAPIException {
        this.publishStage = publishStage;
        if (!this.isRootProject(publishTask.getProject())) {
            publishTask.getLogger().debug("This is not the root project, so this is a no-op");
            return;
        }
        this.scanDependents();
        try (Git git = Git.open((File)((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(this.rootProject.getRootDir())).getGitDir());){
            this.validatePrePublish(git);
            LinkedHashSet<Project> projectsToPublish = new LinkedHashSet<Project>(this.findProjectsToPublish(publishStage, git));
            if (projectsToPublish.isEmpty()) {
                this.rootProject.getLogger().lifecycle("No projects have changed. Not publishing anything");
                return;
            }
            Optional<Project> nextProjectToRelease = this.getNextProjectReadyToPublish(projectsToPublish);
            while (nextProjectToRelease.isPresent()) {
                if (Publisher.hasPublications(nextProjectToRelease.get())) {
                    this.computePublishVersion(publishTask, nextProjectToRelease.get(), git, Publisher.getOrCreateProjectInfo(this.getMultiProjectInfo(), nextProjectToRelease.get()));
                }
                nextProjectToRelease = this.getNextProjectReadyToPublish(projectsToPublish);
            }
            this.updateInfoFile(this.getMultiProjectInfo());
        }
    }

    boolean isRootProject(Project project) {
        return this.rootProject.equals(project.getProject());
    }

    void markPublished(Project project, PublishTarget publishTarget) throws IOException {
        MultiProjectInfo multiProjectInfo = Publisher.readMultiProjectInfoOrDefault(project);
        Optional<ProjectInfo> projectInfoOpt = Publisher.getProjectInfo(multiProjectInfo, project, false);
        if (projectInfoOpt.isEmpty()) {
            return;
        }
        ProjectInfo projectInfo = projectInfoOpt.get();
        projectInfo.getStageInfo(this.getPublishStage(projectInfo)).ifPresent(projectStageInfo -> projectStageInfo.getPendingTargets().remove((Object)publishTarget));
        this.updateInfoFile(multiProjectInfo);
    }

    private Map<Project, Map<PublishStage, PendingVersion>> getCurrentProjectVersions(Project project, MultiProjectInfo multiProjectInfo) {
        TreeMap<Project, Map<PublishStage, PendingVersion>> versionMap = new TreeMap<Project, Map<PublishStage, PendingVersion>>();
        for (Project p : this.getAllProjects().stream().filter(Publisher::hasPublications)::iterator) {
            if (!Publisher.hasPublications(p) || !this.isRootProject(project) && !p.equals(project)) continue;
            for (PublishStage publishStage : PublishStage.values()) {
                versionMap.computeIfAbsent(p, _k -> new LinkedHashMap()).put(publishStage, Publisher.getCurrentProjectVersion(p, publishStage, multiProjectInfo));
            }
        }
        return versionMap;
    }

    private Set<Project> getAllProjects() {
        return this.allProjects;
    }

    private MultiProjectInfo getMultiProjectInfo() throws IOException {
        if (this.multiProjectInfo == null) {
            this.multiProjectInfo = Publisher.readMultiProjectInfoOrDefault(this.rootProject);
        }
        return this.multiProjectInfo;
    }

    private void updateInfoFile(MultiProjectInfo multiProjectInfo) throws IOException {
        OBJECT_MAPPER.writeValue(Publisher.getProjectInfoAbsolutePath(this.rootProject).toFile(), (Object)multiProjectInfo);
        this.multiProjectInfo = multiProjectInfo;
    }

    private PublishStage getPublishStage(ProjectInfo projectInfo) {
        return this.publishStage != null ? this.publishStage : projectInfo.getStageInfos().stream().max(Comparator.comparing(projectStageInfo -> Optional.ofNullable(projectStageInfo.getPublishTime()).orElse(Instant.MIN))).orElseThrow().getStage();
    }

    private static PendingVersion getCurrentProjectVersion(Project project, PublishStage publishStage, MultiProjectInfo multiProjectInfo) {
        ProjectInfo projectInfo = Publisher.getProjectInfo(multiProjectInfo, project, false).orElseThrow();
        Optional<ProjectStageInfo> projectStageInfo = projectInfo.getStageInfo(publishStage).or(() -> projectInfo.getStageInfo(PublishStage.PRODUCTION));
        return new PendingVersion(new Semver(projectStageInfo.map(ProjectStageInfo::getVersion).orElse(DEFAULT_VERSION)), projectStageInfo.map(ProjectStageInfo::getPendingTargets).orElse(new TreeSet()));
    }

    private void validatePrePublish(Git git) throws GitAPIException {
        Preconditions.checkArgument((boolean)RepositoryState.SAFE.equals((Object)git.getRepository().getRepositoryState()), (Object)"Repository is not in stable state. Please finish any unfinished merge/rebase/revert etc.");
        Status status = git.status().call();
        Preconditions.checkArgument((status.isClean() || status.getModified().size() == 1 && this.isProjectInfoPath(Path.of((String)status.getModified().iterator().next(), new String[0]), git) && status.getUntracked().isEmpty() ? 1 : 0) != 0, (Object)"Cannot publish when git working tree is not clean.\nPlease make sure 'git status' reports a clean working tree before mojo publish");
        this.getAllProjects().forEach(project -> Preconditions.checkState((Publisher.getPublications(project).count() <= 1L ? 1 : 0) != 0, (Object)"Mojo publish does not know how to handle projects with multiple publications. Aborting!"));
    }

    private Optional<Project> getNextProjectReadyToPublish(Set<Project> projectsToPublish) {
        Optional<Project> project = projectsToPublish.stream().filter(p -> !this.hasDependencyPendingRelease((Project)p, projectsToPublish)).findAny();
        project.ifPresent(projectsToPublish::remove);
        return project;
    }

    private boolean hasDependencyPendingRelease(Project project, Set<Project> projectsToPublish) {
        return this.projectDependencies.getOrDefault(project, Set.of()).stream().anyMatch(p -> projectsToPublish.contains(p) || this.hasDependencyPendingRelease((Project)p, projectsToPublish));
    }

    private void scanAllProjects() {
        if (this.projectScanCompleted) {
            return;
        }
        this._scanAllProjects(this.rootProject);
        this.projectScanCompleted = true;
    }

    private void _scanAllProjects(Project project) {
        this.allProjects.add(project);
        this.absolutePathToProject.put(project.getProjectDir().toPath(), project);
        project.getSubprojects().forEach(this::_scanAllProjects);
    }

    private static boolean hasPublications(Project project) {
        return Publisher.getPublications(project).findAny().isPresent();
    }

    private static Stream<Publication> getPublications(Project project) {
        return Optional.ofNullable((PublishingExtension)project.getExtensions().findByType(PublishingExtension.class)).map(PublishingExtension::getPublications).stream().flatMap(Collection::stream);
    }

    private Set<Project> findProjectsToPublish(PublishStage publishStage, Git git) throws IOException, GitAPIException {
        LinkedHashSet<Project> projectsToPublish = new LinkedHashSet<Project>();
        String baseCommitId = this.getMultiProjectInfo().getBaseCommitId();
        if (baseCommitId == null) {
            this.rootProject.getLogger().lifecycle("Base commit id is missing for {} in stage {}. Force publishing all projects", new Object[]{this.rootProject, publishStage});
            projectsToPublish.addAll(this.getAllProjects());
        } else {
            ObjectReader reader = git.getRepository().newObjectReader();
            AbstractTreeIterator baseTree = this.getCanonicalTreeParser(git.getRepository().resolve(baseCommitId), reader, git);
            AbstractTreeIterator headTree = this.getCanonicalTreeParser(git.getRepository().resolve("HEAD"), reader, git);
            git.diff().setShowNameOnly(true).setOldTree(baseTree).setNewTree(headTree).call().stream().flatMap(d -> Stream.of(d.getOldPath(), d.getNewPath())).map(x$0 -> Path.of(x$0, new String[0])).distinct().filter(path -> !this.isProjectInfoPath((Path)path, git)).peek(path -> this.rootProject.getLogger().debug("Found changed file {}", path)).map(p -> this.getProjectOf((Path)p, git)).peek(p -> this.rootProject.getLogger().debug("Resolved project for the above path: {}", p)).filter(Optional::isPresent).map(Optional::get).distinct().forEach(project -> this.collectDependentsTransitively((Project)project, (Set<Project>)projectsToPublish));
        }
        return projectsToPublish;
    }

    private void scanDependents() {
        for (Project project : this.getAllProjects()) {
            ConfigurationContainer configurations = project.getConfigurations();
            Set<Project> allProjectDependencies = configurations.getAsMap().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("test")).map(Map.Entry::getValue).map(Configuration::getAllDependencies).map(d -> d.withType(ProjectDependency.class)).flatMap(Collection::stream).map(ProjectDependency::getDependencyProject).collect(Collectors.toSet());
            this.projectDependencies.put(project, allProjectDependencies);
            allProjectDependencies.forEach(p -> this.projectToDependendents.computeIfAbsent((Project)p, _p -> new LinkedHashSet()).add(project));
        }
    }

    private boolean isProjectInfoPath(Path path, Git git) {
        Path projectInfoAbsolutePath = Publisher.getProjectInfoAbsolutePath(this.rootProject);
        return path.equals(projectInfoAbsolutePath) || git.getRepository().getDirectory().toPath().getParent().relativize(projectInfoAbsolutePath).equals(path);
    }

    private AbstractTreeIterator getCanonicalTreeParser(ObjectId commitId, ObjectReader reader, Git git) throws IOException {
        try (RevWalk walk = new RevWalk(git.getRepository());){
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            ObjectId treeId = commit.getTree().getId();
            CanonicalTreeParser canonicalTreeParser = new CanonicalTreeParser(null, reader, (AnyObjectId)treeId);
            return canonicalTreeParser;
        }
    }

    private void collectDependentsTransitively(Project project, Set<Project> collector) {
        collector.add(project);
        for (Project p : this.projectToDependendents.getOrDefault(project, Set.of())) {
            this.collectDependentsTransitively(p, collector);
        }
    }

    private Optional<Project> getProjectOf(Path path, Git git) {
        Path repoRoot = git.getRepository().getDirectory().toPath().getParent().toAbsolutePath();
        do {
            Project project;
            if ((project = this.absolutePathToProject.get(repoRoot.resolve(path))) == null) continue;
            return Optional.of(project);
        } while ((path = path.getParent()) != null);
        return Optional.empty();
    }

    private void computePublishVersion(PublishTask publishTask, Project project, Git git, ProjectInfo projectInfo) throws IOException {
        Semver currentVersion = Publisher.getCurrentProjectVersion(project, this.publishStage, this.getMultiProjectInfo()).version();
        boolean shouldIncrementVersion = PublishStage.PRODUCTION.equals((Object)projectInfo.getStageInfo(this.publishStage).map(ProjectStageInfo::getStage).orElse(PublishStage.PRODUCTION));
        Semver nextVersion = shouldIncrementVersion ? publishTask.getPublishLevel().toNextVersion(currentVersion) : currentVersion.withClearedSuffixAndBuild();
        String featureName = publishTask.getFeatureName();
        if (featureName == null) {
            featureName = git.getRepository().getBranch();
        }
        String semVerString = this.publishStage.decorateVersion(nextVersion, featureName).getValue();
        ProjectStageInfo projectStageInfo = projectInfo.getStageInfo(this.publishStage).orElseGet(() -> {
            ProjectStageInfo stageInfo = new ProjectStageInfo();
            stageInfo.setStage(this.publishStage);
            projectInfo.getStageInfos().add(stageInfo);
            return stageInfo;
        });
        projectStageInfo.setVersion(semVerString);
        String commitId = git.getRepository().resolve("HEAD").name();
        projectStageInfo.setCommitId(commitId);
        projectStageInfo.setPublishTime(Instant.now());
        projectStageInfo.setPendingTargets(Set.of(PublishTarget.LOCAL, PublishTarget.REMOTE));
        if (PublishStage.PRODUCTION.equals((Object)this.publishStage)) {
            this.getMultiProjectInfo().setBaseCommitId(commitId);
            projectInfo.getStageInfos().removeIf(stageInfo -> PublishStage.DEV.equals((Object)stageInfo.getStage()));
        }
        project.getLogger().lifecycle("Publishing {} with version {}", new Object[]{project.getDisplayName(), semVerString});
    }

    private static ProjectInfo getOrCreateProjectInfo(MultiProjectInfo multiProjectInfo, Project project) {
        return Publisher.getProjectInfo(multiProjectInfo, project, true).orElseThrow();
    }

    private static Optional<ProjectInfo> getProjectInfo(MultiProjectInfo multiProjectInfo, Project project, boolean createIfAbsent) {
        String projectName = project.getName();
        List<ProjectInfo> projects = multiProjectInfo.getProjects();
        ProjectInfo projectInfo = projects.stream().filter(p -> projectName.equals(p.getName())).findAny().orElse(null);
        if (projectInfo == null && createIfAbsent) {
            projectInfo = new ProjectInfo(projectName);
            projectInfo.getStageInfos().add(new ProjectStageInfo(PublishStage.PRODUCTION, DEFAULT_VERSION, null, Instant.now(), new TreeSet<PublishTarget>()));
            projects.add(projectInfo);
        }
        return Optional.ofNullable(projectInfo);
    }

    private static MultiProjectInfo readMultiProjectInfoOrDefault(Project project) throws IOException {
        File repoInfoFile = Publisher.getProjectInfoAbsolutePath(project).toFile();
        if (repoInfoFile.exists()) {
            return (MultiProjectInfo)OBJECT_MAPPER.readValue(repoInfoFile, MultiProjectInfo.class);
        }
        return new MultiProjectInfo();
    }

    private static Path getProjectInfoAbsolutePath(Project project) {
        return project.getRootDir().toPath().resolve("multi_project_info.mojo.yaml");
    }

    private record PendingVersion(Semver version, Set<PublishTarget> pendingTargets) {
        @Override
        public String toString() {
            return this.version + " " + this.pendingTargets.stream().map(PublishTarget::shortString).collect(Collectors.joining(",", "[", "]")).replace("[]", "");
        }
    }
}

