/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lois.channel.impl;

import com.flipkart.lois.channel.exceptions.ChannelClosedException;
import com.flipkart.lois.channel.impl.BufferedChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedPassByRefChannel<T>
extends BufferedChannel<T> {
    public BufferedPassByRefChannel(int bufferSize) {
        super(bufferSize);
    }

    @Override
    public void send(T message) throws ChannelClosedException, InterruptedException {
        if (!this.isOpen()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        this.buffer.put(message);
    }

    @Override
    public void send(T message, long timeOut, TimeUnit timeUnit) throws ChannelClosedException, InterruptedException, TimeoutException {
        if (!this.isOpen()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        boolean sent = this.buffer.offer(message, timeOut, timeUnit);
        if (!sent) {
            throw new TimeoutException("Send Operation Timed Out");
        }
    }

    @Override
    public boolean trySend(T message) throws ChannelClosedException {
        if (this.isOpen()) {
            return this.buffer.offer(message);
        }
        throw new ChannelClosedException("Channel has been closed");
    }
}

