/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.lois.channel.impl;

import com.flipkart.lois.channel.api.Channel;
import com.flipkart.lois.channel.api.ReceiveChannel;
import com.flipkart.lois.channel.api.SendChannel;
import com.flipkart.lois.channel.exceptions.ChannelClosedException;
import com.flipkart.lois.utils.Replicant;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedChannel<T>
implements Channel<T> {
    protected final ArrayBlockingQueue<T> buffer;
    protected volatile boolean isChannelOpen = true;
    private final int bufferSize;

    public BufferedChannel(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = new ArrayBlockingQueue(bufferSize, true);
    }

    @Override
    public T receive() throws ChannelClosedException, InterruptedException {
        if (!this.isOpen() && this.buffer.isEmpty()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        return this.buffer.take();
    }

    @Override
    public T receive(long timeOut, TimeUnit timeUnit) throws ChannelClosedException, InterruptedException, TimeoutException {
        if (!this.isOpen() && this.buffer.isEmpty()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        T message = this.buffer.poll(timeOut, timeUnit);
        if (message == null) {
            throw new TimeoutException("Receive Operation Timed Out");
        }
        return message;
    }

    @Override
    public T tryReceive() throws ChannelClosedException {
        T message = this.buffer.poll();
        if (message == null && !this.isOpen()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        return message;
    }

    @Override
    public void send(T message) throws ChannelClosedException, InterruptedException {
        if (!this.isOpen()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        this.buffer.put(BufferedChannel.replicateMessage(message));
    }

    @Override
    public void send(T message, long timeOut, TimeUnit timeUnit) throws ChannelClosedException, InterruptedException, TimeoutException {
        if (!this.isOpen()) {
            throw new ChannelClosedException("Channel has been closed");
        }
        boolean sent = this.buffer.offer(BufferedChannel.replicateMessage(message), timeOut, timeUnit);
        if (!sent) {
            throw new TimeoutException("Send Operation Timed Out");
        }
    }

    @Override
    public boolean trySend(T message) throws ChannelClosedException {
        if (this.isOpen()) {
            return this.buffer.offer(BufferedChannel.replicateMessage(message));
        }
        throw new ChannelClosedException("Channel has been closed");
    }

    @Override
    public void close() {
        this.isChannelOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.isChannelOpen;
    }

    @Override
    public boolean isReceivable() throws ChannelClosedException {
        return this.buffer.remainingCapacity() < this.bufferSize;
    }

    @Override
    public boolean isSendable() throws ChannelClosedException {
        return this.buffer.remainingCapacity() > 0;
    }

    private static <T> T replicateMessage(T message) {
        if (message instanceof SendChannel || message instanceof ReceiveChannel) {
            return message;
        }
        return Replicant.replicate(message);
    }
}

