/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lego.gracekelly.LoaderCallable;
import lego.gracekelly.api.CacheLoader;
import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;
import lego.gracekelly.exceptions.KellyException;
import lego.gracekelly.helpers.Ticker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kelly<T> {
    private final CacheLoader<T> cacheLoader;
    private final CacheProvider<T> cacheProvider;
    private final ExecutorService executorService;
    private final ConcurrentMap<String, Boolean> requestsInFlight;

    public Kelly(CacheProvider<T> cacheProvider, CacheLoader<T> cacheLoader, int executorPoolSize) {
        this.cacheProvider = cacheProvider;
        this.cacheLoader = cacheLoader;
        this.executorService = Executors.newFixedThreadPool(executorPoolSize);
        this.requestsInFlight = new ConcurrentHashMap<String, Boolean>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String key) throws KellyException {
        CacheEntry<T> cacheEntry = null;
        try {
            cacheEntry = this.cacheProvider.get(key);
        }
        catch (CacheProviderException e) {
            throw new KellyException(e);
        }
        if (cacheEntry != null) {
            if (this.cacheEntryExpired(cacheEntry)) {
                ConcurrentMap<String, Boolean> concurrentMap = this.requestsInFlight;
                synchronized (concurrentMap) {
                    if (!this.requestInFlight(cacheEntry)) {
                        try {
                            this.putRequestInFlight(cacheEntry);
                            this.reloadCacheEntry(cacheEntry);
                        }
                        catch (ExecutionException e) {
                            throw new KellyException(e);
                        }
                        catch (InterruptedException e) {
                            throw new KellyException(e);
                        }
                    }
                }
            }
            return cacheEntry.getValue();
        }
        return null;
    }

    public boolean put(String key, CacheEntry<T> value) throws KellyException {
        try {
            return this.cacheProvider.put(key, value);
        }
        catch (CacheProviderException e) {
            throw new KellyException(e);
        }
    }

    public void expire(String key) throws KellyException {
        T value = this.get(key);
        CacheEntry<T> cacheEntry = new CacheEntry<T>(key, value, -10L);
        this.put(key, cacheEntry);
        this.get(key);
    }

    private boolean cacheEntryExpired(CacheEntry cacheEntry) {
        if (cacheEntry.getTtl() == 0L) {
            return false;
        }
        long entryTimeStamp = cacheEntry.getEpoch_timestamp();
        long currentTime = Ticker.read();
        long ttl = cacheEntry.getTtl();
        return entryTimeStamp + ttl <= currentTime;
    }

    private void reloadCacheEntry(CacheEntry cacheEntry) throws ExecutionException, InterruptedException {
        LoaderCallable<T> loaderCallable = new LoaderCallable<T>(this, this.cacheProvider, this.cacheLoader, cacheEntry);
        this.executorService.submit(loaderCallable);
    }

    private boolean requestInFlight(CacheEntry<T> cacheEntry) {
        return this.requestsInFlight.containsKey(cacheEntry.getKey());
    }

    private void putRequestInFlight(CacheEntry<T> cacheEntry) {
        this.requestsInFlight.put(cacheEntry.getKey(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequestInFlight(CacheEntry<T> cacheEntry) {
        ConcurrentMap<String, Boolean> concurrentMap = this.requestsInFlight;
        synchronized (concurrentMap) {
            this.requestsInFlight.remove(cacheEntry.getKey());
        }
    }
}

