/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.cacheproviders.redis;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;

public class RedisCacheProvider
implements CacheProvider<String> {
    private final JedisSentinelPool pool;
    private final ObjectMapper mapper;

    public RedisCacheProvider(JedisSentinelPool pool, ObjectMapper mapper) {
        this.pool = pool;
        this.mapper = mapper;
    }

    public CacheEntry<String> get(String key) throws CacheProviderException {
        assert (this.pool != null);
        Throwable throwable = null;
        try (Jedis jedis = this.pool.getResource();){
            String valueFromCache = jedis.get(key);
            if (StringUtils.isNotBlank((CharSequence)valueFromCache)) {
                CacheEntry cacheEntry = (CacheEntry)this.mapper.readValue(valueFromCache, (TypeReference)new TypeReference<CacheEntry<String>>(){});
                return cacheEntry;
            }
            CacheEntry<String> cacheEntry = null;
            return cacheEntry;
        }
        catch (Exception e) {
            try {
                throw new CacheProviderException((Throwable)e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean put(String key, CacheEntry<String> cacheEntry) throws CacheProviderException {
        assert (this.pool != null);
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(key, this.mapper.writeValueAsString(cacheEntry));
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new CacheProviderException((Throwable)e);
        }
    }
}

