/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.cacheproviders.highlevel;

import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackCacheProvider<T>
implements CacheProvider<T> {
    private final CacheProvider<T> primaryCache;
    private final CacheProvider<T> fallbackCache;

    public FallbackCacheProvider(CacheProvider<T> primaryCache, CacheProvider<T> fallbackCache) {
        this.primaryCache = primaryCache;
        this.fallbackCache = fallbackCache;
    }

    public CacheEntry<T> get(String key) throws CacheProviderException {
        CacheEntry cacheEntry = this.primaryCache.get(key);
        if (cacheEntry == null) {
            cacheEntry = this.fallbackCache.get(key);
        }
        return cacheEntry;
    }

    public Boolean put(String key, CacheEntry<T> value) throws CacheProviderException {
        boolean primaryPut = false;
        primaryPut = this.primaryCache.put(key, value);
        this.fallbackCache.put(key, value);
        return primaryPut;
    }
}

