/*
 * Decompiled with CFR 0.152.
 */
package lego.gracekelly.cacheproviders.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import lego.gracekelly.api.CacheProvider;
import lego.gracekelly.entities.CacheEntry;
import lego.gracekelly.exceptions.CacheProviderException;
import net.spy.memcached.MemcachedClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedProvider<T>
implements CacheProvider<T> {
    private final MemcachedClient memcachedClient;
    private static final int INFINTITE_TTL = 0;

    public MemcachedProvider(InetSocketAddress inetSocketAddress) throws CacheProviderException {
        try {
            this.memcachedClient = new MemcachedClient(new InetSocketAddress[]{inetSocketAddress});
        }
        catch (IOException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }

    public CacheEntry<T> get(String key) throws CacheProviderException {
        return (CacheEntry)this.memcachedClient.get(key);
    }

    public Boolean put(String key, CacheEntry<T> value) throws CacheProviderException {
        try {
            return (Boolean)this.memcachedClient.set(key, 0, value).get();
        }
        catch (InterruptedException e) {
            throw new CacheProviderException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new CacheProviderException((Throwable)e);
        }
    }
}

