/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDef;
import com.flipkart.krystal.vajram.tags.AnnotationTag;
import com.flipkart.krystal.vajram.tags.AnnotationTagKey;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Vajrams {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(Vajrams.class);

    public static @UnknownKeyFor @NonNull @Initialized String getVajramIdString(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Vajram> aClass) {
        Class<? extends Vajram> annotatedClass = aClass;
        do {
            VajramDef annotation;
            if ((annotation = annotatedClass.getAnnotation(VajramDef.class)) == null) continue;
            return annotatedClass.getSimpleName();
        } while ((annotatedClass = annotatedClass.getSuperclass()) != null && Vajram.class.isAssignableFrom(annotatedClass));
        throw new IllegalStateException("Unable to find vajramId for class %s".formatted(aClass));
    }

    public static @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Tag> parseFacetTags(@UnknownKeyFor @NonNull @Initialized Field facetField) {
        Annotation[] annotations;
        LinkedHashMap<AnnotationTagKey, AnnotationTag<Annotation>> tags = new LinkedHashMap<AnnotationTagKey, AnnotationTag<Annotation>>();
        for (Annotation annotation : annotations = facetField.getAnnotations()) {
            boolean isRepeatable;
            boolean bl = isRepeatable = annotation.getClass().getAnnotation(Repeatable.class) != null;
            if (isRepeatable) {
                log.info("Repeatable annotations are not supported as tags. Ignoring {}", (Object)annotation);
                continue;
            }
            AnnotationTag<Annotation> annotationTag = AnnotationTag.from(annotation);
            tags.put(annotationTag.tagKey(), annotationTag);
        }
        return ImmutableMap.copyOf(tags);
    }

    private Vajrams() {
    }
}

