/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.batching;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputBatcherImpl<@UnknownKeyFor I, @UnknownKeyFor C>
implements InputBatcher<I, C> {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BATCH_SIZE = 1;
    private @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized BatchedFacets<I, C>>> batchingListener;
    private final @UnknownKeyFor @NonNull @Initialized Map<C, @UnknownKeyFor @NonNull @Initialized List<I>> unBatchedRequests = new HashMap<C, List<I>>();
    private @UnknownKeyFor @NonNull @Initialized int minBatchSize = 1;

    public InputBatcherImpl() {
    }

    public InputBatcherImpl(@UnknownKeyFor @NonNull @Initialized int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized BatchedFacets<I, C>> add(I batchableInputs, C commonFacets) {
        this.unBatchedRequests.computeIfAbsent(commonFacets, k -> new ArrayList()).add(batchableInputs);
        return this.getBatchedInputs(commonFacets, false);
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized BatchedFacets<I, C>> getBatchedInputs(C commonFacets, @UnknownKeyFor @NonNull @Initialized boolean force) {
        if (commonFacets == null) {
            return ImmutableList.of();
        }
        ImmutableList batchableInputs = ImmutableList.copyOf((Collection)((Collection)this.unBatchedRequests.getOrDefault(commonFacets, (List<I>)ImmutableList.of())));
        if (force || batchableInputs.size() >= this.minBatchSize) {
            this.unBatchedRequests.put(commonFacets, new ArrayList());
            return ImmutableList.of(new BatchedFacets(batchableInputs, commonFacets));
        }
        return ImmutableList.of();
    }

    @Override
    public void batch() {
        ImmutableList batchedFacets = (ImmutableList)this.unBatchedRequests.keySet().stream().map(c -> this.getBatchedInputs(c, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.batchingListener != null) {
            this.batchingListener.accept(batchedFacets);
        }
    }

    @Override
    public void onBatching(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized BatchedFacets<I, C>>> listener) {
        this.batchingListener = listener;
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.minBatchSize = configProvider.getConfig("min_batch_size").orElse(1);
    }
}

