/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramDepFanoutTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramDepSingleTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramDependencySpec;
import com.flipkart.krystal.vajram.inputs.VajramFacetSpec;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.ResolutionRequest;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolverSpec;
import com.flipkart.krystal.vajram.inputs.resolution.SkipPredicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputResolverUtil {
    public static @UnknownKeyFor @NonNull @Initialized ResolutionResult multiResolve(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResolutionRequest> resolutionRequests, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SimpleInputResolver<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> resolvers, @UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        LinkedHashMap<String, List<Map<String, @Nullable Object>>> results = new LinkedHashMap<String, List<Map<String, Object>>>();
        LinkedHashMap<String, DependencyCommand<Inputs>> skippedDependencies = new LinkedHashMap<String, DependencyCommand<Inputs>>();
        for (ResolutionRequest resolutionRequest : resolutionRequests) {
            String dependencyName = resolutionRequest.dependencyName();
            ArrayList<Map<String, @Nullable Object>> depInputs = new ArrayList<Map<String, Object>>();
            Collection depResolvers = resolvers.getOrDefault(dependencyName, List.of());
            for (SimpleInputResolver simpleResolver : depResolvers) {
                String resolvable = simpleResolver.getResolverSpec().getTargetInput().name();
                DependencyCommand command = InputResolverUtil._resolutionHelper(simpleResolver.getResolverSpec().getSourceInput(), simpleResolver.getResolverSpec().getTransformer(), simpleResolver.getResolverSpec().getFanoutTransformer(), simpleResolver.getResolverSpec().getSkipConditions(), inputs);
                if (command.shouldSkip()) {
                    skippedDependencies.put(dependencyName, command);
                    break;
                }
                InputResolverUtil.collectDepInputs(depInputs, resolvable, command);
            }
            if (skippedDependencies.containsKey(dependencyName)) continue;
            results.putIfAbsent(dependencyName, depInputs);
        }
        return new ResolutionResult(results, skippedDependencies);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void collectDepInputs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>> depInputs, @Nullable @UnknownKeyFor @Initialized String resolvable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> command) {
        if (command.shouldSkip()) {
            return;
        }
        if (command instanceof SingleExecute) {
            SingleExecute singleExecute = (SingleExecute)command;
            if (depInputs.isEmpty()) {
                depInputs.add(new LinkedHashMap());
            }
            depInputs.forEach(map -> InputResolverUtil.handleResolverReturn(resolvable, singleExecute.input(), map));
        } else if (command instanceof MultiExecute) {
            MultiExecute multiExecute = (MultiExecute)command;
            Collection<Object> objects = multiExecute.multiInputs();
            if (depInputs.isEmpty()) {
                objects.forEach(o -> {
                    LinkedHashMap<String, @Nullable Object> e = new LinkedHashMap<String, Object>();
                    depInputs.add(e);
                    InputResolverUtil.handleResolverReturn(resolvable, o, e);
                });
            } else {
                ArrayList<LinkedHashMap<String, @Nullable Object>> more = new ArrayList<LinkedHashMap<String, Object>>(depInputs.size() * objects.size() - depInputs.size());
                for (Map<String, Object> depInput : depInputs) {
                    boolean first = true;
                    @Nullable ImmutableMap originalDepInput = ImmutableMap.copyOf(depInput);
                    for (Object t : objects) {
                        if (first) {
                            first = false;
                            InputResolverUtil.handleResolverReturn(resolvable, t, depInput);
                            continue;
                        }
                        LinkedHashMap<String, @Nullable Object> e = new LinkedHashMap<String, Object>((Map<String, Object>)originalDepInput);
                        more.add(e);
                        InputResolverUtil.handleResolverReturn(resolvable, t, e);
                    }
                }
                depInputs.addAll(more);
            }
        }
    }

    private static void handleResolverReturn(@Nullable @UnknownKeyFor @Initialized String resolvable, @Nullable @UnknownKeyFor @Initialized Object o, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object> valuesMap) {
        if (o instanceof Inputs) {
            Inputs inputs = (Inputs)o;
            for (Map.Entry e : inputs.values().entrySet()) {
                if (valuesMap.put((String)e.getKey(), ((ValueOrError)e.getValue()).value().orElse(null)) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
        } else if (resolvable != null) {
            valuesMap.put(resolvable, o);
        } else {
            throw new AssertionError((Object)"Resolvable is null and resolver return is not of Inputs. This should not be possible");
        }
    }

    static <T> @UnknownKeyFor @NonNull @Initialized DependencyCommand<T> _resolutionHelper(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized VajramFacetSpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> sourceInput, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Function<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> oneToOneTransformer, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Function<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>> fanoutTransformer, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SkipPredicate<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> skipPredicates, @UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        boolean fanout;
        boolean bl = fanout = fanoutTransformer != null;
        Optional<Object> inputValue = sourceInput instanceof VajramDepSingleTypeSpec ? ((ValueOrError)inputs.getDepValue(sourceInput.name()).values().values().iterator().next()).value() : (sourceInput instanceof VajramDepFanoutTypeSpec ? Optional.of(inputs.getDepValue(sourceInput.name()).values().values().stream().map(ValueOrError::value).filter(Optional::isPresent).map(Optional::get).toList()) : (sourceInput != null ? inputs.getInputValue(sourceInput.name()).value() : Optional.empty()));
        Optional<SkipPredicate> skipPredicate = skipPredicates.stream().map(p -> p).filter(sSkipPredicate -> sSkipPredicate.condition().test(inputValue)).findFirst();
        if (skipPredicate.isPresent()) {
            if (fanout) {
                return MultiExecute.skipFanout(skipPredicate.get().reason());
            }
            return SingleExecute.skipExecution(skipPredicate.get().reason());
        }
        Function<Optional, Object> transformer = Optional.ofNullable(oneToOneTransformer).or(() -> Optional.ofNullable(fanoutTransformer).map(function -> function.andThen(objects -> objects)).map(x -> x.andThen(Function.identity()))).orElse(Optional::orElseThrow);
        Optional<Object> transformedInput = sourceInput == null ? Optional.ofNullable(transformer.apply(Optional.empty())) : inputValue.map(t -> transformer.apply(Optional.of(t)));
        if (fanout) {
            return MultiExecute.executeFanoutWith((Collection)transformedInput.map(ts -> ((Collection)ts).stream()).stream().flatMap(Function.identity()).collect(ImmutableList.toImmutableList()));
        }
        return SingleExecute.executeWith(transformedInput.orElse(null));
    }

    static <S, T, CV extends Vajram<?>> @UnknownKeyFor @NonNull @Initialized InputResolver toResolver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized VajramDependencySpec<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, CV> dependency, @UnknownKeyFor @NonNull @Initialized SimpleInputResolverSpec<S, T> spec) {
        return new SimpleInputResolver<S, T, CV>(dependency, spec);
    }

    private InputResolverUtil() {
    }

    public record ResolutionResult(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>>> results, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Inputs>> skippedDependencies) {
    }
}

