/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.inputs.resolution;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramDependencyTypeSpec;
import com.flipkart.krystal.vajram.inputs.VajramInputTypeSpec;
import com.flipkart.krystal.vajram.inputs.resolution.AbstractInputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolverSpec;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;

public final class SimpleInputResolver<S, T, CV extends Vajram<?>, DV extends Vajram<?>>
extends AbstractInputResolver {
    public static final LongAdder TIME = new LongAdder();
    private final VajramDependencyTypeSpec<?, CV, DV> dependency;
    private final SimpleInputResolverSpec<S, T, CV, DV> resolverSpec;

    SimpleInputResolver(VajramDependencyTypeSpec<?, CV, DV> dependency, SimpleInputResolverSpec<S, T, CV, DV> resolverSpec) {
        super((ImmutableSet<String>)((ImmutableSet)Optional.ofNullable(resolverSpec.getSourceInput()).stream().map(VajramInputTypeSpec::name).collect(ImmutableSet.toImmutableSet())), new QualifiedInputs(dependency.name(), resolverSpec.getTargetInput().name()));
        this.dependency = dependency;
        this.resolverSpec = resolverSpec;
    }

    public VajramDependencyTypeSpec<?, ?, ?> getDependency() {
        return this.dependency;
    }

    public SimpleInputResolverSpec<?, ?, ?, ?> getResolverSpec() {
        return this.resolverSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DependencyCommand<Inputs> resolve(String dependencyName, ImmutableSet<String> inputsToResolve, Inputs inputs) {
        long start = System.nanoTime();
        try {
            DependencyCommand depCommand = InputResolverUtil._resolutionHelper(this.resolverSpec.getSourceInput(), this.resolverSpec.getTransformer(), this.resolverSpec.getFanoutTransformer(), this.resolverSpec.getSkipConditions(), inputs);
            boolean shouldSkip = depCommand.shouldSkip();
            if (depCommand instanceof SingleExecute) {
                SingleExecute singleExecute = (SingleExecute)depCommand;
                if (shouldSkip) {
                    SingleExecute<Inputs> singleExecute2 = SingleExecute.skipExecution(singleExecute.doc());
                    return singleExecute2;
                }
                SingleExecute<Inputs> singleExecute3 = SingleExecute.executeWith(new Inputs(ImmutableMap.of((Object)this.resolverSpec.getTargetInput().name(), (Object)ValueOrError.withValue(singleExecute.input()))));
                return singleExecute3;
            }
            if (shouldSkip) {
                MultiExecute<Inputs> multiExecute = MultiExecute.skipFanout(depCommand.doc());
                return multiExecute;
            }
            MultiExecute<Inputs> multiExecute = MultiExecute.executeFanoutWith(depCommand.inputs().stream().map(o -> new Inputs(ImmutableMap.of((Object)this.resolverSpec.getTargetInput().name(), (Object)new ValueOrError(o, Optional.empty())))).toList());
            return multiExecute;
        }
        finally {
            TIME.add(System.nanoTime() - start);
        }
    }
}

