/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.das;

import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.das.AccessSpecIndex;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.GraphQl;
import com.flipkart.krystal.vajram.das.GraphQlIndex;
import com.flipkart.krystal.vajram.das.VajramIDIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class VajramIndex {
    private static final Set<Class<? extends DataAccessSpec>> SUPPORTED_ACCESS_SPECS = Set.of(VajramID.class, GraphQl.class);
    private final Map<Class<? extends DataAccessSpec>, AccessSpecIndex<? extends DataAccessSpec>> accessSpecIndices = new HashMap<Class<? extends DataAccessSpec>, AccessSpecIndex<? extends DataAccessSpec>>();

    public VajramIndex() {
        SUPPORTED_ACCESS_SPECS.forEach(aClass -> {
            if (VajramID.class.equals(aClass)) {
                this.accessSpecIndices.put(VajramID.class, new VajramIDIndex());
            } else if (GraphQl.class.equals(aClass)) {
                this.accessSpecIndices.put(GraphQl.class, new GraphQlIndex());
            }
        });
    }

    public <T extends DataAccessSpec> AccessSpecMatchingResult<T> getVajrams(T accessSpec) {
        return this.accessSpecIndices.get(accessSpec.getClass()).getVajrams(accessSpec);
    }

    public void add(Vajram vajram) {
        this.accessSpecIndices.values().forEach(accessSpecIndex -> accessSpecIndex.add(vajram));
    }
}

