/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.vajram.VajramRequest;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;

public record DependencyResponse<R extends VajramRequest, V>(ImmutableMap<R, ValueOrError<V>> responses) {
    public ValueOrError<V> get(R request) {
        return (ValueOrError)this.responses.getOrDefault(request, (Object)ValueOrError.empty());
    }

    public V getOrThrow(R request, Supplier<Exception> exceptionSupplier) throws Exception {
        return (V)((ValueOrError)this.responses.getOrDefault(request, (Object)ValueOrError.empty())).value().orElseThrow(exceptionSupplier);
    }

    public V getOnlyValueOrThrow() {
        ValueOrError<V> value = this.getOnlyValue();
        if (value.error().isPresent()) {
            throw new IllegalStateException("Received an error.", (Throwable)value.error().get());
        }
        if (value.value().isEmpty()) {
            throw new IllegalStateException("Received empty response.");
        }
        return (V)value.value().get();
    }

    private ValueOrError<V> getOnlyValue() {
        ImmutableCollection<ValueOrError<V>> values = this.values();
        if (values.size() != 1) {
            throw new IllegalStateException("Expected to find 1 dependency response, found %s".formatted(values.size()));
        }
        return (ValueOrError)values.iterator().next();
    }

    public ImmutableCollection<ValueOrError<V>> values() {
        return this.responses.values();
    }
}

