/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.exec;

import com.flipkart.krystal.logic.LogicTag;
import com.flipkart.krystal.vajram.ComputeVajram;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.Tag;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramLogic;
import com.flipkart.krystal.vajram.inputs.DefaultInputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.InputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.QualifiedInputs;
import com.flipkart.krystal.vajram.inputs.Resolve;
import com.flipkart.krystal.vajram.inputs.Using;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.tags.Service;
import com.flipkart.krystal.vajram.tags.ServiceApi;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class VajramDefinition {
    private final Vajram<?> vajram;
    private final ImmutableCollection<InputResolverDefinition> inputResolverDefinitions;
    private final ImmutableMap<String, LogicTag> mainLogicTags;

    public VajramDefinition(Vajram<?> vajram) {
        this.vajram = vajram;
        this.inputResolverDefinitions = ImmutableList.copyOf(VajramDefinition.parseInputResolvers(vajram));
        this.mainLogicTags = VajramDefinition.parseVajramLogicTags(vajram);
    }

    private static Collection<InputResolverDefinition> parseInputResolvers(Vajram<?> vajram) {
        ArrayList<InputResolverDefinition> inputResolvers = new ArrayList<InputResolverDefinition>((Collection<InputResolverDefinition>)vajram.getSimpleInputResolvers());
        ImmutableSet resolverMethods = (ImmutableSet)Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Resolve.class)).collect(ImmutableSet.toImmutableSet());
        ImmutableMap inputDefinitions = (ImmutableMap)vajram.getInputDefinitions().stream().filter(vi -> vi instanceof Dependency).map(vi -> (Dependency)vi).collect(ImmutableMap.toImmutableMap(VajramInputDefinition::name, Function.identity()));
        for (Method resolverMethod : resolverMethods) {
            Resolve resolver = resolverMethod.getAnnotation(Resolve.class);
            String targetDependency = resolver.depName();
            Dependency dependency = (Dependency)inputDefinitions.get((Object)targetDependency);
            if (dependency == null) {
                throw new IllegalStateException("Could not find dependency with name %s".formatted(targetDependency));
            }
            Object[] targetInputs = resolver.depInputs();
            ImmutableSet sources = (ImmutableSet)Arrays.stream(resolverMethod.getParameters()).map(Parameter::getAnnotations).map(annotations -> Arrays.stream(annotations).filter(annotation -> annotation instanceof Using).map(annotation -> (Using)annotation).findAny()).filter(Optional::isPresent).map(Optional::orElseThrow).toList().stream().map(Using::value).collect(ImmutableSet.toImmutableSet());
            inputResolvers.add(new DefaultInputResolverDefinition((ImmutableSet<String>)sources, new QualifiedInputs(targetDependency, dependency.dataAccessSpec(), (ImmutableSet<String>)ImmutableSet.copyOf((Object[])targetInputs))));
        }
        return inputResolvers;
    }

    private static ImmutableMap<String, LogicTag> parseVajramLogicTags(Vajram<?> vajram) {
        Tag[] tags = Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(VajramLogic.class) != null).findAny().map(method -> (Tag[])method.getAnnotationsByType(Tag.class)).orElse(new Tag[0]);
        Map<String, LogicTag> collect = Arrays.stream(tags).collect(Collectors.toMap(Tag::name, tag -> new LogicTag(tag.name(), tag.value())));
        Arrays.stream(VajramDefinition.getVajramSourceClass(vajram.getClass()).getDeclaredMethods()).filter(method -> method.getAnnotation(VajramLogic.class) != null).findFirst().ifPresent(method -> {
            ServiceApi serviceApi;
            Service service = method.getAnnotation(Service.class);
            if (service != null) {
                collect.put("service", new LogicTag("service", service.value()));
            }
            if ((serviceApi = method.getAnnotation(ServiceApi.class)) != null) {
                collect.put("service_api", new LogicTag("service_api", serviceApi.apiName()));
            }
            collect.put("vajram_id", new LogicTag("vajram_id", vajram.getId().vajramId()));
            collect.put("vajram_type", new LogicTag("vajram_type", vajram instanceof IOVajram ? "io_vajram" : "compute_vajram"));
        });
        return ImmutableMap.copyOf(collect);
    }

    private static Class<?> getVajramSourceClass(Class<?> vajramClass) {
        Class<?> superclass = vajramClass.getSuperclass();
        if (Object.class.equals(superclass)) {
            throw new IllegalArgumentException();
        }
        if (IOVajram.class.equals(superclass) || ComputeVajram.class.equals(superclass)) {
            return vajramClass;
        }
        return VajramDefinition.getVajramSourceClass(superclass);
    }

    public Vajram<?> getVajram() {
        return this.vajram;
    }

    public ImmutableCollection<InputResolverDefinition> getInputResolverDefinitions() {
        return this.inputResolverDefinitions;
    }

    public ImmutableMap<String, LogicTag> getMainLogicTags() {
        return this.mainLogicTags;
    }
}

