/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram;

import com.flipkart.krystal.vajram.Vajrams;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import java.util.Collection;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class VajramID
implements DataAccessSpec {
    private @MonotonicNonNull String vajramId;
    private final @MonotonicNonNull String className;

    private VajramID(String vajramId, String className) {
        this.vajramId = vajramId;
        this.className = className;
    }

    public static VajramID vajramID(String id) {
        return new VajramID(id, null);
    }

    public static VajramID fromClass(String vajramClassName) {
        return new VajramID(null, vajramClassName);
    }

    public String vajramId() {
        if (this.vajramId == null) {
            Optional<String> className = this.className();
            if (className.isPresent()) {
                try {
                    this.vajramId = Vajrams.getVajramIdString(this.getClass().getClassLoader().loadClass(className.get())).orElseThrow(() -> new IllegalStateException("Couldn't find vajram Id in vajram class %s".formatted(this.className)));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalStateException("Either 'vajramId' or 'className' must be non-null");
            }
        }
        return this.vajramId;
    }

    @Override
    public <T> T adapt(Collection<T> dataObjects) {
        throw new UnsupportedOperationException("");
    }

    public String toString() {
        return "v<%s>".formatted(this.vajramId());
    }

    private Optional<String> className() {
        return Optional.ofNullable(this.className);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VajramID)) {
            return false;
        }
        VajramID other = (VajramID)o;
        String this$vajramId = this.vajramId;
        String other$vajramId = other.vajramId;
        if (this$vajramId == null ? other$vajramId != null : !this$vajramId.equals(other$vajramId)) {
            return false;
        }
        String this$className = this.className;
        String other$className = other.className;
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vajramId = this.vajramId;
        result = result * 59 + ($vajramId == null ? 43 : $vajramId.hashCode());
        String $className = this.className;
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        return result;
    }
}

