/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.modulation;

import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class Batcher
implements InputModulator<InputValuesAdaptor, InputValuesAdaptor> {
    private final List<Consumer<ImmutableList<ModulatedInput<InputValuesAdaptor, InputValuesAdaptor>>>> terminationListeners = new ArrayList<Consumer<ImmutableList<ModulatedInput<InputValuesAdaptor, InputValuesAdaptor>>>>();
    private final Map<InputValuesAdaptor, List<InputValuesAdaptor>> unModulatedRequests = new HashMap<InputValuesAdaptor, List<InputValuesAdaptor>>();
    private final int minBatchSize;

    public Batcher(int minBatchSize) {
        this.minBatchSize = minBatchSize;
    }

    @Override
    public ImmutableList<ModulatedInput<InputValuesAdaptor, InputValuesAdaptor>> add(InputValuesAdaptor inputsNeedingModulation, InputValuesAdaptor commonInputs) {
        this.unModulatedRequests.computeIfAbsent(commonInputs, k -> new ArrayList()).add(inputsNeedingModulation);
        return this.getModulatedInputs(commonInputs, false);
    }

    private ImmutableList<ModulatedInput<InputValuesAdaptor, InputValuesAdaptor>> getModulatedInputs(InputValuesAdaptor commonInputs, boolean force) {
        ImmutableList inputsNeedingModulations = ImmutableList.copyOf((Collection)this.unModulatedRequests.get(commonInputs));
        if (force || inputsNeedingModulations.size() >= this.minBatchSize) {
            this.unModulatedRequests.put(commonInputs, new ArrayList());
            return ImmutableList.of(new ModulatedInput(inputsNeedingModulations, commonInputs));
        }
        return ImmutableList.of();
    }

    @Override
    public void terminate() {
        ImmutableList modulatedInputs = (ImmutableList)this.unModulatedRequests.keySet().stream().map(commonInputs -> this.getModulatedInputs((InputValuesAdaptor)commonInputs, true)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        this.terminationListeners.forEach(modulatedInputConsumer -> modulatedInputConsumer.accept(modulatedInputs));
    }

    @Override
    public void onTermination(Consumer<ImmutableList<ModulatedInput<InputValuesAdaptor, InputValuesAdaptor>>> listener) {
        this.terminationListeners.add(listener);
    }
}

