/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.resilience4j.curcuitbreaker;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.vajram.resilience4j.R4JUtils;
import com.flipkart.krystal.vajram.resilience4j.curcuitbreaker.Resilience4JCircuitBreakerManager;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Resilience4JCircuitBreaker
implements OutputLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JCircuitBreaker.class.getName();
    private final String instanceId;
    private @Nullable CircuitBreaker circuitBreaker;

    public Resilience4JCircuitBreaker(String instanceId) {
        this.instanceId = instanceId;
    }

    public static Resilience4JCircuitBreakerManager onePerIOVajram() {
        return Resilience4JCircuitBreaker.onePerInstanceId(logicExecutionContext -> logicExecutionContext.vajramID().id());
    }

    public static Resilience4JCircuitBreakerManager onePerInstanceId(Function<LogicExecutionContext, String> instanceIdGenerator) {
        return new Resilience4JCircuitBreakerManager(instanceIdGenerator);
    }

    public OutputLogic<Object> decorateLogic(OutputLogic<Object> logicToDecorate, OutputLogicDefinition<Object> originalLogicDefinition) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        if (circuitBreaker != null) {
            return input -> R4JUtils.decorateAsyncExecute(logicToDecorate, input).withCircuitBreaker(circuitBreaker).get();
        }
        return logicToDecorate;
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.updateCircuitBreaker(configProvider);
    }

    private void init(ConfigProvider configProvider) {
        this.circuitBreaker = this.getCircuitBreakerConfig(configProvider).map(config -> new CircuitBreakerStateMachine(this.instanceId + ".circuit_breaker", config)).orElse(null);
    }

    private Optional<CircuitBreakerConfig> getCircuitBreakerConfig(ConfigProvider configProvider) {
        boolean circuitBreakerDisabled;
        boolean bl = circuitBreakerDisabled = configProvider.getConfig(this.instanceId + ".circuit_breaker.enabled").orElse(true) == false;
        if (circuitBreakerDisabled) {
            return Optional.empty();
        }
        return Optional.of(CircuitBreakerConfig.ofDefaults());
    }

    private void updateCircuitBreaker(ConfigProvider configProvider) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        Optional<CircuitBreakerConfig> newConfig = this.getCircuitBreakerConfig(configProvider);
        if (!Optional.ofNullable(circuitBreaker).map(CircuitBreaker::getCircuitBreakerConfig).equals(newConfig)) {
            this.init(configProvider);
        }
    }
}

