/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VajramProto3ServiceSchemaGen
implements CodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VajramProto3ServiceSchemaGen.class);
    private final AllVajramCodeGenContext creationContext;
    private final CodeGenUtility util;

    public VajramProto3ServiceSchemaGen(AllVajramCodeGenContext creationContext) {
        this.creationContext = creationContext;
        this.util = creationContext.util();
    }

    public void generate() throws VajramValidationException {
        List<VajramInfo> applicableVajrams = VajramProto3ServiceSchemaGen.getApplicable(this.creationContext, this.util);
        VajramProto3ServiceSchemaGen.validate(applicableVajrams, this.util);
        this.generateServiceFiles(applicableVajrams);
    }

    private static List<VajramInfo> getApplicable(AllVajramCodeGenContext creationContext, CodeGenUtility util) {
        if (!CodegenPhase.MODELS.equals((Object)creationContext.codegenPhase())) {
            util.note((CharSequence)"Skipping protobuf codegen since current phase is not MODELS");
            return List.of();
        }
        return creationContext.vajramInfos().stream().filter(vajramInfo -> ProtoGenUtils.isProto3Applicable(vajramInfo, util)).toList();
    }

    static void validate(List<VajramInfo> vajramInfos, CodeGenUtility util) throws VajramValidationException {
        for (VajramInfo vajramInfo : vajramInfos) {
            ProtoGenUtils.validateReturnTypeForProtobuf(vajramInfo, util);
        }
    }

    private void generateServiceFiles(List<VajramInfo> vajramInfos) {
        Map<String, List<VajramInfo>> vajramsByPackageName = vajramInfos.stream().collect(Collectors.groupingBy(vajramInfo -> vajramInfo.lite().packageName()));
        try {
            Path outputDir = ProtoGenUtils.createOutputDirectory(this.util.detectSourceOutputPath(null), this.util);
            vajramsByPackageName.forEach((packageName, vajramInfosForServiceName) -> {
                String responseTypeName;
                String vajramId;
                int lastDotIndex = packageName.lastIndexOf(46);
                String serviceName = ProtoGenUtils.capitalize(lastDotIndex == -1 ? packageName : packageName.substring(lastDotIndex + 1));
                String serviceProtoFileName = serviceName + ".service.proto";
                StringBuilder protoBuilder = new StringBuilder();
                protoBuilder.append("// AUTOMATICALLY GENERATED - DO NOT EDIT!\n").append("// This schema is auto-generated by Krystal's code generator.\n").append("// It defines the service for Vajrams inside the package ").append((String)packageName).append("\n").append("// Any manual edits to this file will be overwritten.\n\n");
                protoBuilder.append("syntax = \"proto3\";\n\n");
                protoBuilder.append("package ").append((String)packageName).append(";\n\n");
                protoBuilder.append("option java_package = \"").append((String)packageName).append("\";\n");
                protoBuilder.append("option java_multiple_files = true;\n\n");
                protoBuilder.append("// Service definition for the remotely invocable Vajrams inside package %s\n".formatted(packageName));
                for (VajramInfo vajramInfo : vajramInfosForServiceName) {
                    vajramId = vajramInfo.vajramName();
                    responseTypeName = ProtoGenUtils.getSimpleClassName(vajramInfo.lite().responseType().canonicalClassName());
                    protoBuilder.append("import \"").append(vajramId).append("_Req.models.proto").append("\";\n");
                    protoBuilder.append("import \"").append(responseTypeName).append(".models.proto").append("\";\n\n");
                }
                protoBuilder.append("service ").append(serviceName).append(" {\n");
                for (VajramInfo vajramInfo : vajramInfosForServiceName) {
                    vajramId = vajramInfo.vajramName();
                    responseTypeName = ProtoGenUtils.getSimpleClassName(vajramInfo.lite().responseType().canonicalClassName());
                    protoBuilder.append("  // Execute the Vajram remotely\n");
                    protoBuilder.append("  rpc Execute(").append(vajramId).append("_Req_Proto").append(") returns (").append(ProtoGenUtils.getPackageName(vajramInfo.lite().responseType().canonicalClassName()).filter(s -> !s.equals(packageName)).map(s -> s + ".").orElse("")).append(responseTypeName).append("_Proto").append(");\n");
                }
                protoBuilder.append("}\n");
                Path serviceProtoFilePath = outputDir.resolve(serviceProtoFileName);
                log.info("Generated service protobuf schema file: {}", (Object)serviceProtoFilePath);
                try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(serviceProtoFilePath, new OpenOption[0]));){
                    out.println(protoBuilder);
                }
                catch (IOException e) {
                    this.util.error("Failed to generate service proto file %s".formatted(serviceProtoFilePath), new Element[0]);
                }
            });
        }
        catch (IOException e) {
            this.util.error(String.format("Error generating protobuf service definition for %s: %s", vajramInfos, e.getMessage()), new Element[0]);
        }
    }
}

