/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.vajram.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.vajram.codegen.common.datatypes.StandardJavaType;
import com.flipkart.krystal.vajram.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.vajram.protobuf3.codegen.ModelsProto3SchemaGen;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsProto3Gen
implements CodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelsProto3Gen.class);
    private final ModelsCodeGenContext codeGenContext;
    private final CodeGenUtility util;

    public ModelsProto3Gen(ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        this.validate();
        this.generateProtoImplementation();
    }

    private boolean isApplicable() {
        if (!CodegenPhase.FINAL.equals((Object)this.codeGenContext.codegenPhase())) {
            this.util.note((CharSequence)"Skipping protobuf codegen since current phase is not FINAL");
            return false;
        }
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelRoot modelRootAnnotation = modelRootType.getAnnotation(ModelRoot.class);
        if (modelRootAnnotation == null) {
            this.util.note((CharSequence)"Skipping class '%s' since it doesn't have @ModelRoot annotation".formatted(modelRootType.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void validate() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelsProto3SchemaGen.validateModelType(modelRootType, this.util);
    }

    private void generateProtoImplementation() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        String modelRootName = modelRootType.getSimpleName().toString();
        String packageName = this.util.processingEnv().getElementUtils().getPackageOf(modelRootType).toString();
        String protoClassName = modelRootName + modelRoot.suffixSeparator() + "ImmutProto";
        TypeSpec typeSpec = this.generateImplementationTypeSpec(modelRootType, packageName, protoClassName);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        this.util.generateSourceFile(packageName + "." + protoClassName, javaFile.toString(), modelRootType);
        log.info("Generated protobuf implementation class: {}", (Object)protoClassName);
    }

    private TypeSpec generateImplementationTypeSpec(TypeElement modelRootType, String packageName, String protoClassName) {
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        String modelRootName = modelRootType.getSimpleName().toString();
        String immutInterfaceName = modelRootName + modelRoot.suffixSeparator() + "Immut";
        String protoMsgClassName = modelRootName + "_Proto";
        List modelMethods = this.util.extractAndValidateModelMethods(modelRootType);
        AnnotationSpec suppressWarningsAnnotation = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$L", new Object[]{"{\"unchecked\", \"ClassReferencesSubclass\"}"}).build();
        ClassName immutInterfaceClassName = ClassName.get((String)packageName, (String)immutInterfaceName, (String[])new String[0]);
        ClassName serializableClassName = ClassName.get(SerializableModel.class);
        ArrayTypeName byteArrayType = ArrayTypeName.of((TypeName)TypeName.BYTE);
        ClassName protoMsgType = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeName nullableProtoMsgType = protoMsgType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)protoClassName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(suppressWarningsAnnotation).addSuperinterface((TypeName)immutInterfaceClassName).addSuperinterface((TypeName)serializableClassName);
        this.util.addGeneratedAnnotations(classBuilder);
        classBuilder.addField(FieldSpec.builder((TypeName)byteArrayType, (String)"_serializedPayload", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)nullableProtoMsgType, (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)byteArrayType, "_serializedPayload", new Modifier[0]).addStatement("this._serializedPayload = _serializedPayload", new Object[0]).addStatement("this._proto = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)protoMsgType, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).addStatement("this._serializedPayload = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_serialize").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)byteArrayType).beginControlFlow("if (_serializedPayload == null)", new Object[0]).addStatement("this._serializedPayload = _proto.toByteArray()", new Object[0]).endControlFlow().addStatement("return _serializedPayload", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutInterfaceClassName).addStatement("return this", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto().toBuilder())", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableProtoType).addCode("if(_serializedPayload != null) {\n  return new $L(_serializedPayload);\n} else if(_proto != null){\n  return new $L(_proto);\n} else {\n  throw new $T(\"Both _proto and _serializedPayload are null\");\n}\n", new Object[]{protoClassName, protoClassName, IllegalStateException.class}).build());
        MethodSpec.Builder getProtoMsgBuilder = MethodSpec.methodBuilder((String)"_proto").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)protoMsgType).beginControlFlow("if (_proto == null && _serializedPayload != null)", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("_proto = $T.parseFrom(_serializedPayload)", new Object[]{protoMsgType}).nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new RuntimeException(\"Failed to deserialize proto message\", e)", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (_proto == null)", new Object[0]).addStatement("throw new IllegalStateException(\"Both _proto and _serializedPayload are null\")", new Object[0]).endControlFlow().addStatement("return _proto", new Object[0]);
        classBuilder.addMethod(getProtoMsgBuilder.build());
        for (ExecutableElement method : modelMethods) {
            TypeMirror returnType = method.getReturnType();
            CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            TypeName typeName = TypeName.get((TypeMirror)returnType);
            classBuilder.addMethod(this.getterMethod(method, returnType, typeName, dataType).build());
        }
        MethodSpec equalsMethod = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "obj", new Modifier[0]).addCode("if (this == obj) {\n  return true;\n}\nif (obj == null || getClass() != obj.getClass()) {\n  return false;\n}\n$L other = ($L) obj;\nreturn _proto().equals(other._proto());\n", new Object[]{protoClassName, protoClassName}).build();
        classBuilder.addMethod(equalsMethod);
        MethodSpec hashCodeMethod = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addStatement("return _proto().hashCode()", new Object[0]).build();
        classBuilder.addMethod(hashCodeMethod);
        TypeSpec builderTypeSpec = this.generateBuilderTypeSpec(modelRootType, packageName, protoClassName, protoMsgClassName, immutInterfaceName, modelMethods);
        classBuilder.addType(builderTypeSpec);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableProtoType.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableProtoType.nestedClass("Builder")}).build());
        return classBuilder.build();
    }

    private MethodSpec.Builder getterMethod(ExecutableElement method, TypeMirror returnType, TypeName typeName, CodeGenType dataType) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.needsPresenceCheckInModels(method) && !this.isMandatoryField(method) && !this.util.isOptional(returnType)) {
            getterBuilder.returns(typeName.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}));
        } else {
            getterBuilder.returns(typeName);
        }
        this.addGetterCode(getterBuilder, method, dataType, methodName);
        return getterBuilder;
    }

    private void addGetterCode(MethodSpec.Builder getterBuilder, ExecutableElement method, CodeGenType dataType, String methodName) {
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            getterBuilder.addStatement("return _proto().get$LList()", new Object[]{ProtoGenUtils.capitalize(methodName)});
            return;
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            getterBuilder.addStatement("return _proto().get$LMap()", new Object[]{ProtoGenUtils.capitalize(methodName)});
            return;
        }
        boolean isOptionalReturnType = this.util.isOptional(method.getReturnType());
        if (this.needsPresenceCheckInModels(method)) {
            CodeBlock protoPresenceCheck = CodeBlock.of((String)"if (!_proto().has$L()){\n", (Object[])new Object[]{ProtoGenUtils.capitalize(methodName)});
            if (this.isMandatoryField(method)) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  throw new IllegalStateException(\"Field $L is mandatory but has no value\");\n}\n", new Object[]{methodName});
            } else if (isOptionalReturnType) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return Optional.empty();\n}\n", new Object[0]);
            } else {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return null;\n}\n", new Object[0]);
            }
        }
        if (isOptionalReturnType) {
            getterBuilder.addStatement("return Optional.of(_proto().get$L())", new Object[]{ProtoGenUtils.capitalize(methodName)});
        } else {
            getterBuilder.addStatement("return _proto().get$L()", new Object[]{ProtoGenUtils.capitalize(methodName)});
        }
    }

    private TypeSpec generateBuilderTypeSpec(TypeElement modelRootType, String packageName, String protoClassName, String protoMsgClassName, String immutInterfaceName, List<ExecutableElement> modelMethods) {
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        ClassName builderInterfaceClassName = ClassName.get((String)packageName, (String)immutInterfaceName, (String[])new String[0]).nestedClass("Builder");
        ClassName protoBuilderClassName = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]).nestedClass("Builder");
        ClassName protoMsgClassNameObj = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)builderInterfaceClassName);
        this.util.addGeneratedAnnotations(builderClassBuilder);
        builderClassBuilder.addField(FieldSpec.builder((TypeName)protoBuilderClassName, (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)protoBuilderClassName, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this._proto = $T.newBuilder()", new Object[]{protoMsgClassNameObj}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableProtoType).addStatement("return new $L(_proto.build())", new Object[]{protoClassName}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return this", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto.clone())", new Object[0]).build());
        for (ExecutableElement method : modelMethods) {
            TypeName typeName;
            String methodName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            boolean isOptionalReturnType = this.util.isOptional(returnType);
            if (isOptionalReturnType) {
                TypeMirror innerType = this.util.getOptionalInnerType(returnType);
                typeName = TypeName.get((TypeMirror)innerType);
            } else {
                typeName = TypeName.get((TypeMirror)returnType);
            }
            if (typeName.isPrimitive()) {
                typeName = typeName.box();
            }
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0]));
            ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)typeName, (String)methodName, (Modifier[])new Modifier[0]);
            paramBuilder.addAnnotation(Nullable.class);
            if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.addAll$L($L);\n", new Object[]{ProtoGenUtils.capitalize(methodName), methodName, ProtoGenUtils.capitalize(methodName), methodName});
            } else if (ProtoGenUtils.isProtoTypeMap(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.putAll$L($L);\n", new Object[]{ProtoGenUtils.capitalize(methodName), methodName, ProtoGenUtils.capitalize(methodName), methodName});
            } else {
                setterBuilder.addCode("  if ($L == null){\n    _proto.clear$L();\n    return this;\n  }\n", new Object[]{methodName, ProtoGenUtils.capitalize(methodName)});
                setterBuilder.addStatement(dataType.equals(StandardJavaType.BYTE) ? "_proto.set$L(com.google.protobuf.ByteString.copyFrom(new byte[]{$L}))" : "_proto.set$L($L)", new Object[]{ProtoGenUtils.capitalize(methodName), methodName});
            }
            setterBuilder.addStatement("return this", new Object[0]);
            builderClassBuilder.addMethod(setterBuilder.addParameter(paramBuilder.build()).build());
            if (!modelRoot.builderExtendsModelRoot()) continue;
            builderClassBuilder.addMethod(this.getterMethod(method, returnType, typeName, dataType).build());
        }
        return builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_proto").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)protoBuilderClassName).addStatement("return _proto", new Object[0]).build()).build();
    }

    private boolean needsPresenceCheckInModels(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType, null);
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            return false;
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            return false;
        }
        return !this.util.getIfAbsent((Element)method).value().usePlatformDefault();
    }

    private boolean isMandatoryField(ExecutableElement method) {
        return this.util.getIfAbsent((Element)method).value() == IfAbsent.IfAbsentThen.FAIL;
    }
}

