/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.data.IfAbsent;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.model.Model;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.serial.SerialId;
import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.OptionalFieldType;
import com.flipkart.krystal.vajram.protobuf3.codegen.types.ProtoFieldType;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelsProto3SchemaGen
implements CodeGenerator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(ModelsProto3SchemaGen.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ModelsCodeGenContext codeGenContext;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util;

    public ModelsProto3SchemaGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        this.validate();
        this.generateProtobufSchema();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isApplicable() {
        if (!CodegenPhase.MODELS.equals((Object)this.codeGenContext.codegenPhase())) {
            this.util.note((CharSequence)"Skipping protobuf codegen since current phase is not MODELS");
            return false;
        }
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        if (modelRootType == null) {
            this.util.note((CharSequence)"Skipping protobuf codegen since model root type is null");
            return false;
        }
        ModelRoot modelRootAnnotation = modelRootType.getAnnotation(ModelRoot.class);
        if (modelRootAnnotation == null) {
            this.util.note((CharSequence)"Skipping class '%s' since it doesn't have @ModelRoot annotation".formatted(modelRootType.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void validate() {
        ModelsProto3SchemaGen.validateModelType(this.codeGenContext.modelRootType(), this.util);
    }

    static void validateModelType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement modelRootType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        if (!ElementKind.INTERFACE.equals((Object)modelRootType.getKind())) {
            util.error("Model root '%s' must be an interface".formatted(modelRootType), (Element)modelRootType);
        }
        if (!util.isRawAssignable(modelRootType.asType(), Model.class)) {
            util.error("Model root '%s' must implement Model interface".formatted(modelRootType), (Element)modelRootType);
        }
    }

    private void generateProtobufSchema() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        String modelRootName = modelRootType.getSimpleName().toString();
        String packageName = this.util.processingEnv().getElementUtils().getPackageOf(modelRootType).toString();
        String protoFileName = modelRootName + ".models.proto";
        try {
            Path outputDir = ProtoGenUtils.createOutputDirectory(this.util.detectSourceOutputPath((Element)modelRootType), this.util);
            String protoContent = this.generateProtoFileContent(modelRootType, packageName);
            Path protoFilePath = outputDir.resolve(protoFileName);
            try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(protoFilePath, new OpenOption[0]));){
                out.println(protoContent);
            }
            log.info("Generated protobuf schema file: {}", (Object)protoFilePath);
        }
        catch (IOException e) {
            this.util.error(String.format("Error generating protobuf schema for %s: %s", modelRootName, e.getMessage()), (Element)modelRootType);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String generateProtoFileContent(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement modelRootType, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName) {
        StringBuilder protoBuilder = new StringBuilder();
        String modelRootName = modelRootType.getSimpleName().toString();
        protoBuilder.append("// AUTOMATICALLY GENERATED - DO NOT EDIT!\n").append("// This schema is auto-generated by Krystal's code generator.\n").append("// It models the proto for Model Root: ").append(modelRootName).append("\n").append("// Source: ").append(modelRootType.getQualifiedName()).append("\n").append("// Any manual edits to this file will be overwritten.\n\n");
        protoBuilder.append("syntax = \"proto3\";\n\n");
        protoBuilder.append("package ").append(packageName).append(";\n\n");
        protoBuilder.append("option java_package = \"").append(packageName).append("\";\n");
        protoBuilder.append("option java_multiple_files = true;\n");
        protoBuilder.append("option java_outer_classname = \"").append(modelRootName).append("_ModelsProto\";\n\n");
        protoBuilder.append("message ").append(modelRootName).append("_Proto {\n");
        List<ExecutableElement> modelMethods = this.extractModelMethods(modelRootType);
        HashSet<Integer> usedFieldNumbers = new HashSet<Integer>();
        for (ExecutableElement method : modelMethods) {
            int fieldNumber;
            SerialId serialId = method.getAnnotation(SerialId.class);
            if (serialId == null) {
                this.util.error(String.format("Missing @SerialId annotation on method '%s' in Model Root '%s'", method.getSimpleName(), modelRootName), (Element)method);
                fieldNumber = -1;
            } else {
                fieldNumber = serialId.value();
            }
            if (fieldNumber <= 0) {
                this.util.error(String.format("Invalid SerialId %d for method '%s' in Model Root '%s'. SerialId must be positive.", fieldNumber, method.getSimpleName(), modelRootName), (Element)method);
            }
            if (!usedFieldNumbers.add(fieldNumber)) {
                this.util.error(String.format("Duplicate SerialId %d for method '%s' in Model Root '%s'", fieldNumber, method.getSimpleName(), modelRootName), (Element)method);
            }
            DataType dataType = (DataType)new DeclaredTypeVisitor(this.util, (Element)method).visit(method.getReturnType());
            boolean isOptional = true;
            IfAbsent.IfAbsentThen ifAbsentThen = Utils.getIfNoValue((ExecutableElement)method).value();
            boolean isRepeated = ProtoGenUtils.isProtoTypeRepeated(dataType);
            boolean isMap = ProtoGenUtils.isProtoTypeMap(dataType);
            if ((isRepeated || isMap) && !ifAbsentThen.usePlatformDefault()) {
                this.util.error(String.format("Method '%s' in Model Root '%s' is a %s field, and has @IfNoValue(then=%s) which is not supported in protobuf3. Use a different IfNoValue strategy.", method.getSimpleName(), modelRootName, isRepeated ? "repeated" : "map", ifAbsentThen), (Element)method);
            } else if (ifAbsentThen.usePlatformDefault()) {
                isOptional = false;
            }
            String documentation = this.util.processingEnv().getElementUtils().getDocComment(method);
            if (documentation != null && !documentation.trim().isEmpty()) {
                Iterable docLines = Splitter.on((char)'\n').split((CharSequence)documentation);
                for (String line : docLines) {
                    protoBuilder.append("  // ").append(line.trim()).append("\n");
                }
            }
            protoBuilder.append("  ");
            ProtoFieldType protobufType = ProtoGenUtils.getProtobufType(dataType, this.util, method);
            if (isOptional && !(protobufType instanceof OptionalFieldType)) {
                protobufType = new OptionalFieldType(protobufType, this.util, method);
            }
            protoBuilder.append(protobufType.typeInProtoFile()).append(" ").append(method.getSimpleName().toString()).append(" = ").append(fieldNumber).append(";\n");
        }
        protoBuilder.append("}\n");
        return protoBuilder.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ExecutableElement> extractModelMethods(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeElement modelRootType) {
        ArrayList<ExecutableElement> modelMethods = new ArrayList<ExecutableElement>();
        for (Element element : modelRootType.getEnclosedElements()) {
            ExecutableElement method;
            if (!ElementKind.METHOD.equals((Object)element.getKind()) || (method = (ExecutableElement)element).getSimpleName().toString().equals("_build") || method.getSimpleName().toString().equals("_asBuilder") || method.getSimpleName().toString().equals("_newCopy") || !method.getParameters().isEmpty()) continue;
            modelMethods.add(method);
        }
        return modelMethods;
    }
}

