/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.vajram.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.vajram.codegen.common.models.Utils;
import com.flipkart.krystal.vajram.codegen.common.models.VajramInfo;
import com.flipkart.krystal.vajram.codegen.common.models.VajramValidationException;
import com.flipkart.krystal.vajram.codegen.common.spi.AllVajramCodeGenContext;
import com.flipkart.krystal.vajram.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VajramServiceProto3SchemaGen
implements CodeGenerator {
    @Generated
    private static final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Logger log = LoggerFactory.getLogger(VajramServiceProto3SchemaGen.class);
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AllVajramCodeGenContext creationContext;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util;

    public VajramServiceProto3SchemaGen(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AllVajramCodeGenContext creationContext) {
        this.creationContext = creationContext;
        this.util = creationContext.util();
    }

    public void generate() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramValidationException {
        List<VajramInfo> applicableVajrams = VajramServiceProto3SchemaGen.getApplicable(this.creationContext, this.util);
        VajramServiceProto3SchemaGen.validate(applicableVajrams, this.util);
        this.generateServiceFiles(applicableVajrams);
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo> getApplicable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent AllVajramCodeGenContext creationContext, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) {
        if (!CodegenPhase.MODELS.equals((Object)creationContext.codegenPhase())) {
            util.note((CharSequence)"Skipping protobuf codegen since current phase is not MODELS");
            return List.of();
        }
        return creationContext.vajramInfos().stream().filter(vajramInfo -> ProtoGenUtils.isProto3Applicable(vajramInfo, util)).toList();
    }

    static void validate(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo> vajramInfos, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Utils util) throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramValidationException {
        for (VajramInfo vajramInfo : vajramInfos) {
            ProtoGenUtils.validateReturnTypeForProtobuf(vajramInfo, util);
        }
    }

    private void generateServiceFiles(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramInfo> vajramInfos) {
        Map<String, List<VajramInfo>> vajramsByPackageName = vajramInfos.stream().collect(Collectors.groupingBy(vajramInfo -> vajramInfo.lite().packageName()));
        try {
            Path outputDir = ProtoGenUtils.createOutputDirectory(this.util.detectSourceOutputPath(null), this.util);
            vajramsByPackageName.forEach((packageName, vajramInfosForServiceName) -> {
                String responseTypeName;
                String vajramId;
                int lastDotIndex = packageName.lastIndexOf(46);
                String serviceName = ProtoGenUtils.capitalize(lastDotIndex == -1 ? packageName : packageName.substring(lastDotIndex + 1));
                String serviceProtoFileName = serviceName + ".service.proto";
                StringBuilder protoBuilder = new StringBuilder();
                protoBuilder.append("// AUTOMATICALLY GENERATED - DO NOT EDIT!\n").append("// This schema is auto-generated by Krystal's code generator.\n").append("// It defines the service for Vajrams inside the package ").append((String)packageName).append("\n").append("// Any manual edits to this file will be overwritten.\n\n");
                protoBuilder.append("syntax = \"proto3\";\n\n");
                protoBuilder.append("package ").append((String)packageName).append(";\n\n");
                protoBuilder.append("option java_package = \"").append((String)packageName).append("\";\n");
                protoBuilder.append("option java_multiple_files = true;\n\n");
                protoBuilder.append("// Service definition for the remotely invocable Vajrams inside package %s\n".formatted(packageName));
                for (VajramInfo vajramInfo : vajramInfosForServiceName) {
                    vajramId = vajramInfo.vajramName();
                    responseTypeName = ProtoGenUtils.getSimpleClassName(vajramInfo.lite().responseType().canonicalClassName());
                    protoBuilder.append("import \"").append(vajramId).append("_Req.models.proto").append("\";\n");
                    protoBuilder.append("import \"").append(responseTypeName).append(".models.proto").append("\";\n\n");
                }
                protoBuilder.append("service ").append(serviceName).append(" {\n");
                for (VajramInfo vajramInfo : vajramInfosForServiceName) {
                    vajramId = vajramInfo.vajramName();
                    responseTypeName = ProtoGenUtils.getSimpleClassName(vajramInfo.lite().responseType().canonicalClassName());
                    protoBuilder.append("  // Execute the Vajram remotely\n");
                    protoBuilder.append("  rpc Execute(").append(vajramId).append("_Req_Proto").append(") returns (").append(ProtoGenUtils.getPackageName(vajramInfo.lite().responseType().canonicalClassName()).filter(s -> !s.equals(packageName)).map(s -> s + ".").orElse("")).append(responseTypeName).append("_Proto").append(");\n");
                }
                protoBuilder.append("}\n");
                Path serviceProtoFilePath = outputDir.resolve(serviceProtoFileName);
                log.info("Generated service protobuf schema file: {}", (Object)serviceProtoFilePath);
                try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(serviceProtoFilePath, new OpenOption[0]));){
                    out.println(protoBuilder);
                }
                catch (IOException e) {
                    throw this.util.errorAndThrow("Failed to generate service proto file %s".formatted(serviceProtoFilePath), null);
                }
            });
        }
        catch (IOException e) {
            throw this.util.errorAndThrow(String.format("Error generating protobuf service definition for %s: %s", vajramInfos, e.getMessage()), null);
        }
    }
}

