/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.datatypes.StandardJavaType;
import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.DeclaredTypeVisitor;
import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.model.MandatoryFieldMissingException;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.serial.SerializableModel;
import com.flipkart.krystal.vajram.protobuf3.Protobuf3;
import com.flipkart.krystal.vajram.protobuf3.SerializableProtoModel;
import com.flipkart.krystal.vajram.protobuf3.codegen.ModelsProto3SchemaGen;
import com.flipkart.krystal.vajram.protobuf3.codegen.ProtoGenUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsProto3Gen
implements CodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelsProto3Gen.class);
    private final ModelsCodeGenContext codeGenContext;
    private final CodeGenUtility util;

    public ModelsProto3Gen(ModelsCodeGenContext codeGenContext) {
        this.codeGenContext = codeGenContext;
        this.util = codeGenContext.util();
    }

    public void generate() {
        if (!this.isApplicable()) {
            return;
        }
        this.validate();
        this.generateProtoImplementation();
    }

    private boolean isApplicable() {
        if (!CodegenPhase.FINAL.equals((Object)this.codeGenContext.codegenPhase())) {
            this.util.note((CharSequence)"Skipping protobuf models codegen since current phase is not FINAL");
            return false;
        }
        if (!this.isProto3SerdeSupported()) {
            this.util.note((CharSequence)("Skipping protobuf models codegen since Protobuf3 is not a supported protocol of the model " + String.valueOf(this.codeGenContext.modelRootType())));
            return false;
        }
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelRoot modelRootAnnotation = modelRootType.getAnnotation(ModelRoot.class);
        if (modelRootAnnotation == null) {
            this.util.note((CharSequence)"Skipping class '%s' since it doesn't have @ModelRoot annotation".formatted(modelRootType.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean isProto3SerdeSupported() {
        return this.util.typeExplicitlySupportsProtocol(this.codeGenContext.modelRootType(), Protobuf3.class);
    }

    private void validate() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ModelsProto3SchemaGen.validateModelType(modelRootType, this.util);
    }

    private void generateProtoImplementation() {
        TypeElement modelRootType = this.codeGenContext.modelRootType();
        ClassName immutClassName = this.util.getImmutClassName(modelRootType);
        String protoClassName = this.getProtoClassName();
        String packageName = immutClassName.packageName();
        TypeSpec typeSpec = this.generateImplementationTypeSpec(modelRootType, packageName, protoClassName);
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        this.util.generateSourceFile(packageName + "." + protoClassName, javaFile.toString(), modelRootType);
        log.info("Generated protobuf implementation class: {}", (Object)protoClassName);
    }

    private String getProtoClassName() {
        return this.util.getImmutClassName(this.codeGenContext.modelRootType()).simpleName() + Protobuf3.PROTOBUF_3.modelClassesSuffix();
    }

    private TypeSpec generateImplementationTypeSpec(TypeElement modelRootType, String packageName, String protoClassName) {
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        String modelRootName = modelRootType.getSimpleName().toString();
        ClassName immutModelName = this.util.getImmutClassName(modelRootType);
        String protoMsgClassName = modelRootName + "_Proto";
        List modelMethods = this.util.extractAndValidateModelMethods(modelRootType);
        ParameterizedTypeName serializableTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(SerializableProtoModel.class), (TypeName[])new TypeName[]{ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0])});
        ArrayTypeName byteArrayType = ArrayTypeName.of((TypeName)TypeName.BYTE);
        ClassName protoMsgType = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeSpec.Builder classBuilder = this.util.classBuilder(protoClassName, modelRootType.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)immutModelName).addSuperinterface((TypeName)serializableTypeName);
        classBuilder.addField(FieldSpec.builder((TypeName)byteArrayType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(MonotonicNonNull.class).build()}), (String)"_serializedPayload", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addField(FieldSpec.builder((TypeName)protoMsgType.annotated(new AnnotationSpec[]{AnnotationSpec.builder(MonotonicNonNull.class).build()}), (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)byteArrayType, "_serializedPayload", new Modifier[0]).addStatement("this._serializedPayload = _serializedPayload", new Object[0]).addStatement("this._proto = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)protoMsgType, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).addStatement("this._serializedPayload = null", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.util.getMethod(SerializableModel.class, "_serialize", 0)).addCode("if (_serializedPayload == null){\n  this._serializedPayload = _proto.toByteArray();\n}\nreturn _serializedPayload;\n", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutModelName).addStatement("return this", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto().toBuilder())", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableProtoType).addCode("if(_serializedPayload != null) {\n  return new $L(_serializedPayload);\n} else if(_proto != null){\n  return new $L(_proto);\n} else {\n  throw new $T(\"Both _proto and _serializedPayload are null\");\n}\n", new Object[]{protoClassName, protoClassName, IllegalStateException.class}).build());
        MethodSpec.Builder getProtoMsgBuilder = MethodSpec.overriding((ExecutableElement)this.util.getMethod(SerializableProtoModel.class, "_proto", 0)).returns((TypeName)protoMsgType).beginControlFlow("if (_proto == null && _serializedPayload != null)", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("_proto = $T.parseFrom(_serializedPayload)", new Object[]{protoMsgType}).nextControlFlow("catch (Exception e)", new Object[0]).addStatement("throw new RuntimeException(\"Failed to deserialize proto message\", e)", new Object[0]).endControlFlow().endControlFlow().beginControlFlow("if (_proto == null)", new Object[0]).addStatement("throw new IllegalStateException(\"Both _proto and _serializedPayload are null\")", new Object[0]).endControlFlow().addStatement("return _proto", new Object[0]);
        classBuilder.addMethod(getProtoMsgBuilder.build());
        for (ExecutableElement method : modelMethods) {
            TypeMirror returnType = method.getReturnType();
            CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            TypeName typeName = TypeName.get((TypeMirror)returnType);
            classBuilder.addMethod(this.getterMethod(method, returnType, typeName, dataType).build());
        }
        this.util.addImmutableModelObjectMethods(immutModelName, modelMethods.stream().map(ExecutableElement::getSimpleName).collect(Collectors.toSet()), classBuilder);
        TypeSpec builderTypeSpec = this.generateBuilderTypeSpec(modelRootType, packageName, protoClassName, protoMsgClassName, immutModelName, modelMethods);
        classBuilder.addType(builderTypeSpec);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"_builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)immutableProtoType.nestedClass("Builder")).addStatement("return new $T()", new Object[]{immutableProtoType.nestedClass("Builder")}).build());
        return classBuilder.build();
    }

    private MethodSpec.Builder getterMethod(ExecutableElement method, TypeMirror returnType, TypeName typeName, CodeGenType dataType) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder getterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (this.needsPresenceCheckInModels(method) && !this.isMandatoryField(method) && !this.util.isOptional(returnType)) {
            getterBuilder.returns(typeName.annotated(new AnnotationSpec[]{AnnotationSpec.builder(Nullable.class).build()}));
        } else {
            getterBuilder.returns(typeName);
        }
        this.addGetterCode(getterBuilder, method, dataType, methodName);
        return getterBuilder;
    }

    private void addGetterCode(MethodSpec.Builder getterBuilder, ExecutableElement method, CodeGenType dataType, String methodName) {
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            getterBuilder.addStatement("return _proto().get$LList()", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName)});
            return;
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            getterBuilder.addStatement("return _proto().get$LMap()", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName)});
            return;
        }
        boolean isOptionalReturnType = this.util.isOptional(method.getReturnType());
        if (this.needsPresenceCheckInModels(method)) {
            CodeBlock protoPresenceCheck = CodeBlock.of((String)"if (!_proto().has$L()){\n", (Object[])new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName)});
            if (this.isMandatoryField(method)) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  throw new $T($S, $S);\n}\n", new Object[]{MandatoryFieldMissingException.class, this.getProtoClassName(), methodName});
            } else if (isOptionalReturnType) {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return Optional.empty();\n}\n", new Object[0]);
            } else {
                getterBuilder.addCode(protoPresenceCheck).addCode("  return null;\n}\n", new Object[0]);
            }
        }
        if (isOptionalReturnType) {
            getterBuilder.addStatement("return $T.of(_proto().get$L())", new Object[]{Optional.class, CodeGenUtility.capitalizeFirstChar((String)methodName)});
        } else {
            getterBuilder.addStatement("return _proto().get$L()", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName)});
        }
    }

    private TypeSpec generateBuilderTypeSpec(TypeElement modelRootType, String packageName, String protoClassName, String protoMsgClassName, ClassName immutInterfaceName, List<ExecutableElement> modelMethods) {
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        ClassName immutableProtoType = ClassName.get((String)packageName, (String)protoClassName, (String[])new String[0]);
        ClassName builderInterfaceClassName = immutInterfaceName.nestedClass("Builder");
        ClassName protoBuilderClassName = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]).nestedClass("Builder");
        ClassName protoMsgClassNameObj = ClassName.get((String)packageName, (String)protoMsgClassName, (String[])new String[0]);
        TypeSpec.Builder builderClassBuilder = this.util.classBuilder("Builder", modelRootType.getQualifiedName().toString()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)builderInterfaceClassName);
        builderClassBuilder.addField(FieldSpec.builder((TypeName)protoBuilderClassName, (String)"_proto", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)protoBuilderClassName, "_proto", new Modifier[0]).addStatement("this._proto = _proto", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this._proto = $T.newBuilder()", new Object[]{protoMsgClassNameObj}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)immutableProtoType).addStatement("return new $L(_proto.build())", new Object[]{protoClassName}).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_asBuilder").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return this", new Object[0]).build());
        builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_newCopy").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0])).addStatement("return new Builder(_proto.clone())", new Object[0]).build());
        for (ExecutableElement method : modelMethods) {
            TypeName typeName;
            String methodName = method.getSimpleName().toString();
            TypeMirror returnType = method.getReturnType();
            CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType);
            boolean isOptionalReturnType = this.util.isOptional(returnType);
            if (isOptionalReturnType) {
                TypeMirror innerType = this.util.getOptionalInnerType(returnType);
                typeName = TypeName.get((TypeMirror)innerType);
            } else {
                typeName = TypeName.get((TypeMirror)returnType);
            }
            if (typeName.isPrimitive()) {
                typeName = typeName.box();
            }
            MethodSpec.Builder setterBuilder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)"", (String)"Builder", (String[])new String[0]));
            ParameterSpec.Builder paramBuilder = ParameterSpec.builder((TypeName)typeName, (String)methodName, (Modifier[])new Modifier[0]);
            paramBuilder.addAnnotation(Nullable.class);
            if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.addAll$L($L);\n", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName), methodName, CodeGenUtility.capitalizeFirstChar((String)methodName), methodName});
            } else if (ProtoGenUtils.isProtoTypeMap(dataType)) {
                setterBuilder.addCode("  _proto.clear$L();\n  if ($L == null){\n    return this;\n  }\n  _proto.putAll$L($L);\n", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName), methodName, CodeGenUtility.capitalizeFirstChar((String)methodName), methodName});
            } else {
                setterBuilder.addCode("  if ($L == null){\n    _proto.clear$L();\n    return this;\n  }\n", new Object[]{methodName, CodeGenUtility.capitalizeFirstChar((String)methodName)});
                setterBuilder.addStatement(dataType.equals(StandardJavaType.BYTE) ? "_proto.set$L(com.google.protobuf.ByteString.copyFrom(new byte[]{$L}))" : "_proto.set$L($L)", new Object[]{CodeGenUtility.capitalizeFirstChar((String)methodName), methodName});
            }
            setterBuilder.addStatement("return this", new Object[0]);
            builderClassBuilder.addMethod(setterBuilder.addParameter(paramBuilder.build()).build());
            if (!modelRoot.builderExtendsModelRoot()) continue;
            builderClassBuilder.addMethod(this.getterMethod(method, returnType, typeName, dataType).build());
        }
        return builderClassBuilder.addMethod(MethodSpec.methodBuilder((String)"_proto").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)protoBuilderClassName).addStatement("return _proto", new Object[0]).build()).build();
    }

    private boolean needsPresenceCheckInModels(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        CodeGenType dataType = (CodeGenType)new DeclaredTypeVisitor(this.util, (Element)method).visit(returnType, null);
        if (ProtoGenUtils.isProtoTypeRepeated(dataType)) {
            return false;
        }
        if (ProtoGenUtils.isProtoTypeMap(dataType)) {
            return false;
        }
        return !this.util.getIfAbsent((Element)method).value().usePlatformDefault();
    }

    private boolean isMandatoryField(ExecutableElement method) {
        return this.util.getIfAbsent((Element)method).value() == IfAbsent.IfAbsentThen.FAIL;
    }
}

