package com.flipkart.krystal.vajram.protobuf3.codegen;

import com.flipkart.krystal.codegen.common.spi.CodeGenerator;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGenContext;
import com.flipkart.krystal.codegen.common.spi.ModelsCodeGeneratorProvider;
import com.flipkart.krystal.serial.SerializableModel;
import com.google.auto.service.AutoService;

/**
 * This code generator generates implementations in the model root hierarchy. More specifically, it
 * generates a final class name "[ModelName]_ImmutProto" which extends the "[ModelName]_Immut"
 * interface and the {@link SerializableModel} interface. This class wraps the proto java model
 * generated by protoc, whose name is "[ModelName]_Proto". All the getters in the class delegate to
 * the proto model. It also contains a lazily initialized byte array field named
 * "_serializedPayload". This is initialized in a constructor which accepts a byte array. This also
 * generates an inner class inside the ImmutProto class which extends the
 * "[ModelName]_Immut.Builder" interface and wraps a "[ModelName]_Proto.Builder" instance and all
 * setter and getter calls are delegated to this.
 */
@AutoService(ModelsCodeGeneratorProvider.class)
public class ModelsProto3GenProvider implements ModelsCodeGeneratorProvider {

  @Override
  public CodeGenerator create(ModelsCodeGenContext codeGenContext) {
    return new ModelsProto3Gen(codeGenContext);
  }
}
