/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.krystex.caching.RequestLevelCache;
import com.flipkart.krystal.krystex.caching.TestRequestLevelCache;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VajramTestHarness {
    private final Map<VajramID, Map<ImmutableFacetValues, Errable<Object>>> vajramIdMockData;
    private final KrystexVajramExecutorConfig vajramExecutorConfig;
    private final TestRequestLevelCache requestLevelCache;

    @Inject
    public VajramTestHarness(KrystexVajramExecutorConfig krystexVajramExecutorConfig, TestRequestLevelCache requestLevelCache) {
        this.vajramExecutorConfig = krystexVajramExecutorConfig;
        this.requestLevelCache = requestLevelCache;
        this.vajramIdMockData = new HashMap<VajramID, Map<ImmutableFacetValues, Errable<Object>>>();
    }

    public static VajramTestHarness prepareForTest(KrystexVajramExecutorConfig executorConfig, TestRequestLevelCache requestLevelCache) {
        return new VajramTestHarness(executorConfig, requestLevelCache);
    }

    public <T> VajramTestHarness withMock(ImmutableFacetValues facetValues, Errable<T> response) {
        this.vajramIdMockData.computeIfAbsent(facetValues._vajramID(), _k -> new LinkedHashMap()).computeIfAbsent(facetValues, _k -> response);
        return this;
    }

    public KrystexVajramExecutorConfig buildConfig() {
        this.vajramIdMockData.forEach((vajramID, vajramRequestErrableMap) -> vajramRequestErrableMap.forEach((objectVajramRequest, objectErrable) -> this.requestLevelCache.primeCache((FacetValues)objectVajramRequest, objectErrable.toFuture())));
        KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder = this.vajramExecutorConfig.kryonExecutorConfigBuilder();
        KryonDecoratorConfig kryonDecoratorConfig = (KryonDecoratorConfig)configBuilder.build().kryonDecoratorConfigs().get((Object)RequestLevelCache.DECORATOR_TYPE);
        if (kryonDecoratorConfig == null) {
            return this.vajramExecutorConfig.toBuilder().kryonExecutorConfig(this.vajramExecutorConfig.kryonExecutorConfigBuilder().kryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, new KryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, executionContext -> this.vajramIdMockData.containsKey(executionContext.vajramID()), executionContext -> RequestLevelCache.DECORATOR_TYPE, kryonExecutionContext -> this.requestLevelCache)).build()).build();
        }
        return this.vajramExecutorConfig;
    }
}

