/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.traits;

import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Request;
import com.flipkart.krystal.facets.Dependency;
import com.flipkart.krystal.krystex.commands.ClientSideCommand;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardSend;
import com.flipkart.krystal.krystex.commands.VoidResponse;
import com.flipkart.krystal.krystex.dependencydecoration.VajramInvocation;
import com.flipkart.krystal.krystex.dependencydecorators.TraitDispatchDecorator;
import com.flipkart.krystal.krystex.kryon.BatchResponse;
import com.flipkart.krystal.krystex.kryon.KryonCommandResponse;
import com.flipkart.krystal.krystex.request.InvocationId;
import com.flipkart.krystal.traits.DynamicDispatchPolicy;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TraitDispatchDecoratorImpl
implements TraitDispatchDecorator {
    public static final String DECORATOR_TYPE = StaticDispatchPolicy.class.getName();
    private final VajramKryonGraph vajramKryonGraph;
    private final ImmutableMap<VajramID, TraitDispatchPolicy> traitDispatchPolicies;

    public TraitDispatchDecoratorImpl(VajramKryonGraph vajramKryonGraph, ImmutableMap<VajramID, TraitDispatchPolicy> traitDispatchPolicies) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.traitDispatchPolicies = traitDispatchPolicies;
    }

    public <R extends KryonCommandResponse> VajramInvocation<R> decorateDependency(VajramInvocation<R> invocationToDecorate) {
        return kryonCommand -> {
            if (!this.vajramKryonGraph.getVajramDefinition(kryonCommand.vajramID()).isTrait()) {
                return invocationToDecorate.invokeDependency(kryonCommand);
            }
            VajramID traitId = kryonCommand.vajramID();
            Dependency dependency = kryonCommand.dependentChain().latestDependency();
            TraitDispatchPolicy traitDispatchPolicy = (TraitDispatchPolicy)this.traitDispatchPolicies.get((Object)traitId);
            if (traitDispatchPolicy instanceof StaticDispatchPolicy) {
                StaticDispatchPolicy staticDispatchDefinition = (StaticDispatchPolicy)traitDispatchPolicy;
                if (dependency == null) {
                    throw new AssertionError((Object)"This is not possible. A dependency decorator can only be invoked when there is a dependency present.");
                }
                VajramID dispatchTarget = staticDispatchDefinition.getDispatchTargetID(dependency);
                ClientSideCommand commandToDispatch = TraitDispatchDecoratorImpl.transformCommandForDispatch(kryonCommand, dispatchTarget);
                if (commandToDispatch == null) {
                    commandToDispatch = kryonCommand;
                }
                return invocationToDecorate.invokeDependency(commandToDispatch);
            }
            if (traitDispatchPolicy instanceof DynamicDispatchPolicy) {
                DynamicDispatchPolicy dynamicPolicy = (DynamicDispatchPolicy)traitDispatchPolicy;
                if (kryonCommand instanceof ForwardSend) {
                    ForwardSend forwardSend = (ForwardSend)kryonCommand;
                    Map originalExecutableRequests = forwardSend.executableRequests();
                    Map originalSkippedInvocations = forwardSend.skippedInvocations();
                    LinkedHashMap<VajramID, Map<K, @Nullable V>> dispatchRequests = new LinkedHashMap();
                    LinkedHashMap<VajramID, CompletableFuture> dispatchResponses = new LinkedHashMap<VajramID, CompletableFuture>();
                    LinkedHashSet<InvocationId> orphanedRequests = new LinkedHashSet<InvocationId>();
                    for (Map.Entry requestEntry : originalExecutableRequests.entrySet()) {
                        InvocationId invocationId = (InvocationId)requestEntry.getKey();
                        @Nullable Request originalRequest = (Request)requestEntry.getValue();
                        @Nullable VajramID dispatchTarget = dynamicPolicy.getDispatchTargetID(dependency, originalRequest);
                        if (dispatchTarget != null) {
                            dispatchRequests.computeIfAbsent(dispatchTarget, k -> new LinkedHashMap()).put(invocationId, originalRequest);
                            continue;
                        }
                        orphanedRequests.add(invocationId);
                    }
                    ImmutableSet dispatchTargets = dynamicPolicy.dispatchTargetIDs();
                    ImmutableMap requestsToSkip = ImmutableMap.builder().putAll(originalSkippedInvocations).putAll(orphanedRequests.stream().collect(Collectors.toMap(Function.identity(), _r -> "The request did not match any of the configured dynamic dispatch targets of trait: " + String.valueOf(traitId)))).build();
                    for (VajramID dispatchTargetID : dispatchTargets) {
                        ForwardSend commandToDispatch;
                        Map<K, @Nullable V> requestsForTarget = dispatchRequests.getOrDefault(dispatchTargetID, Map.of());
                        if (requestsForTarget.isEmpty()) {
                            LinkedHashMap skipRequests = new LinkedHashMap();
                            skipRequests.putAll(originalExecutableRequests.keySet().stream().collect(Collectors.toMap(Function.identity(), _r -> "None of the requests to trait " + String.valueOf(traitId) + " matched " + String.valueOf(dispatchTargetID) + " via dynamic predicate dispatch")));
                            skipRequests.putAll(requestsToSkip);
                            commandToDispatch = new ForwardSend(dispatchTargetID, (Map)ImmutableMap.of(), forwardSend.dependentChain(), skipRequests);
                        } else {
                            commandToDispatch = new ForwardSend(dispatchTargetID, requestsForTarget, forwardSend.dependentChain(), (Map)requestsToSkip);
                        }
                        CompletableFuture depResponse = invocationToDecorate.invokeDependency((ClientSideCommand)commandToDispatch);
                        dispatchResponses.put(dispatchTargetID, depResponse);
                    }
                    CompletableFuture mergedResponse = new CompletableFuture();
                    CompletableFuture.allOf((CompletableFuture[])dispatchResponses.values().toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
                        LinkedHashMap<InvocationId, @Nullable Errable> mergedResults = new LinkedHashMap<InvocationId, Errable>();
                        for (Map.Entry dispatchResponseEntry : dispatchResponses.entrySet()) {
                            VajramID dispatchTarget = (VajramID)dispatchResponseEntry.getKey();
                            CompletableFuture dispatchResponse = (CompletableFuture)dispatchResponseEntry.getValue();
                            if (dispatchResponse.isCompletedExceptionally()) {
                                try {
                                    dispatchResponse.join();
                                    continue;
                                }
                                catch (Throwable e) {
                                    Set invocationIds = dispatchRequests.getOrDefault(dispatchTarget, Map.of()).keySet();
                                    for (InvocationId id : invocationIds) {
                                        mergedResults.put(id, Errable.withError((Throwable)e));
                                    }
                                    continue;
                                }
                            }
                            BatchResponse resultValue = dispatchResponse.getNow(BatchResponse.empty());
                            mergedResults.putAll(resultValue.responses());
                        }
                        mergedResponse.complete(new BatchResponse((Map)ImmutableMap.copyOf(mergedResults)));
                    });
                    CompletableFuture castMergedResponse = mergedResponse;
                    return castMergedResponse;
                }
                if (kryonCommand instanceof Flush) {
                    Flush flush = (Flush)kryonCommand;
                    ArrayList<CompletableFuture> flushResponses = new ArrayList<CompletableFuture>();
                    for (VajramID dispatchTarget : dynamicPolicy.dispatchTargetIDs()) {
                        CompletableFuture flushResponse = invocationToDecorate.invokeDependency((ClientSideCommand)new Flush(dispatchTarget, flush.dependentChain()));
                        flushResponses.add(flushResponse);
                    }
                    CompletionStage flushResponse = CompletableFuture.allOf((CompletableFuture[])flushResponses.toArray(CompletableFuture[]::new)).handle((unused, throwable) -> VoidResponse.getInstance());
                    return flushResponse;
                }
                throw new IllegalStateException("Unknown command type: " + String.valueOf(kryonCommand));
            }
            throw new IllegalStateException("Unknown dispatch policy: " + String.valueOf(traitDispatchPolicy));
        };
    }

    private static <R extends KryonCommandResponse> @Nullable ClientSideCommand<R> transformCommandForDispatch(ClientSideCommand<R> kryonCommand, VajramID boundVajram) {
        Flush commandToDispatch = null;
        if (kryonCommand instanceof ForwardSend) {
            ForwardSend forwardSend = (ForwardSend)kryonCommand;
            commandToDispatch = new ForwardSend(boundVajram, forwardSend.executableRequests(), forwardSend.dependentChain(), forwardSend.skippedInvocations());
        } else if (kryonCommand instanceof Flush) {
            commandToDispatch = new Flush(boundVajram, kryonCommand.dependentChain());
        }
        return commandToDispatch;
    }

    @Generated
    public ImmutableMap<VajramID, TraitDispatchPolicy> traitDispatchPolicies() {
        return this.traitDispatchPolicies;
    }
}

