/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.batching;

import com.flipkart.krystal.concurrent.Futures;
import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.core.OutputLogicExecutionInput;
import com.flipkart.krystal.core.OutputLogicExecutionResults;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.decoration.DecoratorCommand;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.kryon.DependentChain;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.vajram.batching.BatchEnabledFacetValues;
import com.flipkart.krystal.vajram.batching.BatchedFacets;
import com.flipkart.krystal.vajram.batching.InputBatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class InputBatchingDecorator
implements OutputLogicDecorator {
    public static final String DECORATOR_TYPE = InputBatchingDecorator.class.getName();
    private final String instanceId;
    private final InputBatcher inputBatcher;
    private final Predicate<DependentChain> isApplicableToDependentChain;
    private final Map<ImmutableFacetValues, CompletableFuture<@Nullable Object>> futureCache = new LinkedHashMap<ImmutableFacetValues, CompletableFuture<Object>>();
    private final Set<DependentChain> dependantChainsToFlush = new LinkedHashSet<DependentChain>();
    private @MonotonicNonNull Set<DependentChain> activeDependantChains;
    private @MonotonicNonNull OutputLogicExecutionInput outputLogicExecutionInput;

    public InputBatchingDecorator(String instanceId, InputBatcher inputBatcher, Predicate<DependentChain> isApplicableToDependentChain) {
        this.instanceId = instanceId;
        this.inputBatcher = inputBatcher;
        this.isApplicableToDependentChain = isApplicableToDependentChain;
    }

    public OutputLogic<Object> decorateLogic(OutputLogic<Object> logicToDecorate, OutputLogicDefinition<Object> originalLogicDefinition) {
        this.inputBatcher.onBatching(requests -> requests.forEach(request -> this.batchFacetsList(logicToDecorate, (BatchedFacets)request)));
        return input -> {
            if (this.outputLogicExecutionInput == null) {
                this.outputLogicExecutionInput = input;
            }
            ImmutableList immutableFacetsList = (ImmutableList)input.facetValues().stream().map(f -> {
                if (f instanceof BatchEnabledFacetValues) {
                    return (BatchEnabledFacetValues)f;
                }
                throw new IllegalStateException("Expected to receive instance of BatchEnabledFacetValues in batcher %s but received %s".formatted(this.instanceId, f));
            }).map(BatchEnabledFacetValues::_build).collect(ImmutableList.toImmutableList());
            List batchedFacetsList = immutableFacetsList.stream().map(arg_0 -> ((InputBatcher)this.inputBatcher).add(arg_0)).flatMap(Collection::stream).toList();
            input.facetValues().forEach(facetValues -> this.futureCache.computeIfAbsent(facetValues._build(), e -> new CompletableFuture()));
            for (BatchedFacets batchedFacets : batchedFacetsList) {
                this.batchFacetsList(logicToDecorate, batchedFacets);
            }
            return new OutputLogicExecutionResults((ImmutableMap)input.facetValues().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Objects.requireNonNullElseGet(this.futureCache.get(key._build()), CompletableFuture::new))));
        };
    }

    public void executeCommand(DecoratorCommand logicDecoratorCommand) {
        if (this.activeDependantChains == null && logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            Set allActiveDepChains = initiateActiveDepChains.dependantsChains();
            LinkedHashSet<DependentChain> builder = new LinkedHashSet<DependentChain>(allActiveDepChains.size());
            for (DependentChain activeDepChain : allActiveDepChains) {
                if (!this.isApplicableToDependentChain.test(activeDepChain)) continue;
                builder.add(activeDepChain);
            }
            this.activeDependantChains = Collections.unmodifiableSet(builder);
            this.dependantChainsToFlush.addAll(this.activeDependantChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.dependantChainsToFlush.remove(flushCommand.dependantsChain());
            if (this.dependantChainsToFlush.isEmpty()) {
                this.inputBatcher.batch();
                this.dependantChainsToFlush.addAll(this.activeDependantChains());
            }
        }
    }

    private Set<DependentChain> activeDependantChains() {
        return this.activeDependantChains == null ? ImmutableSet.of() : this.activeDependantChains;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void batchFacetsList(OutputLogic<Object> logicToDecorate, BatchedFacets batchedFacets) {
        OutputLogicExecutionResults result;
        ImmutableList facetsList = batchedFacets.batchItems();
        if (this.outputLogicExecutionInput == null) {
            if (!facetsList.isEmpty()) throw new AssertionError((Object)"The decorateLogic was never invoked by facetsList is not empty. This should not be possible");
            result = new OutputLogicExecutionResults(ImmutableMap.of());
        } else {
            try {
                result = logicToDecorate.execute(this.outputLogicExecutionInput.withFacetValues((List)facetsList));
            }
            catch (Throwable e) {
                result = new OutputLogicExecutionResults((ImmutableMap)facetsList.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), i -> CompletableFuture.failedFuture(e))));
            }
        }
        result.results().forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent(inputs._build(), request -> new CompletableFuture())));
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.inputBatcher.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_batching.%s.", this.instanceId), configProvider));
    }
}

