/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfigurator;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonExecutionContext;
import com.flipkart.krystal.vajram.exec.VajramExecutor;
import com.flipkart.krystal.vajram.inputinjection.VajramInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.KryonInputInjector;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KrystexVajramExecutor
implements VajramExecutor {
    private final VajramKryonGraph vajramKryonGraph;
    private final KrystalExecutor krystalExecutor;

    public KrystexVajramExecutor(@lombok.NonNull VajramKryonGraph vajramKryonGraph, @lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
        if (vajramKryonGraph == null) {
            throw new NullPointerException("vajramKryonGraph is marked non-null but is null");
        }
        if (executorConfig == null) {
            throw new NullPointerException("executorConfig is marked non-null but is null");
        }
        this.vajramKryonGraph = vajramKryonGraph;
        executorConfig.kryonExecutorConfigBuilder().configureWith(KrystexVajramExecutor.kryonInputInjector(vajramKryonGraph, executorConfig)).configureWith(vajramKryonGraph.inputBatchingConfig());
        this.krystalExecutor = new KryonExecutor(vajramKryonGraph.kryonDefinitionRegistry(), executorConfig.kryonExecutorConfigBuilder().build(), executorConfig.requestId());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest request) {
        return this.execute(request, KryonExecutionConfig.builder().executionId("defaultExecution").build());
    }

    public <T> CompletableFuture<@Nullable T> execute(ImmutableRequest vajramRequest, KryonExecutionConfig executionConfig) {
        this.vajramKryonGraph.loadKryonSubGraphIfNeeded(vajramRequest._vajramID());
        return this.krystalExecutor.executeKryon(vajramRequest, executionConfig);
    }

    public KrystalExecutor getKrystalExecutor() {
        return this.krystalExecutor;
    }

    public void close() {
        this.krystalExecutor.close();
    }

    public void shutdownNow() {
        this.krystalExecutor.shutdownNow();
    }

    private static KryonExecutorConfigurator kryonInputInjector(VajramKryonGraph vajramKryonGraph, KrystexVajramExecutorConfig executorConfig) {
        VajramInjectionProvider injectionProvider = executorConfig.inputInjectionProvider();
        if (injectionProvider == null) {
            return KryonExecutorConfigurator.NO_OP;
        }
        return configBuilder -> configBuilder.kryonDecoratorConfig(KryonInputInjector.DECORATOR_TYPE, new KryonDecoratorConfig(KryonInputInjector.DECORATOR_TYPE, executorContext -> KrystexVajramExecutor.isInjectionNeeded(vajramKryonGraph, executorContext), executionContext -> KryonInputInjector.DECORATOR_TYPE, decoratorContext -> new KryonInputInjector(vajramKryonGraph, injectionProvider)));
    }

    private static boolean isInjectionNeeded(VajramKryonGraph vajramKryonGraph, KryonExecutionContext executionContext) {
        return vajramKryonGraph.getVajramDefinition(executionContext.vajramID()).metadata().isInputInjectionNeeded();
    }

    @Generated
    public static @NonNull KrystexVajramExecutorBuilder builder() {
        return new KrystexVajramExecutorBuilder();
    }

    @Generated
    public static class KrystexVajramExecutorBuilder {
        @Generated
        private VajramKryonGraph vajramKryonGraph;
        @Generated
        private KrystexVajramExecutorConfig executorConfig;

        @Generated
        KrystexVajramExecutorBuilder() {
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder vajramKryonGraph(@lombok.NonNull VajramKryonGraph vajramKryonGraph) {
            if (vajramKryonGraph == null) {
                throw new NullPointerException("vajramKryonGraph is marked non-null but is null");
            }
            this.vajramKryonGraph = vajramKryonGraph;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutorBuilder executorConfig(@lombok.NonNull KrystexVajramExecutorConfig executorConfig) {
            if (executorConfig == null) {
                throw new NullPointerException("executorConfig is marked non-null but is null");
            }
            this.executorConfig = executorConfig;
            return this;
        }

        @Generated
        public @NonNull KrystexVajramExecutor build() {
            return new KrystexVajramExecutor(this.vajramKryonGraph, this.executorConfig);
        }

        @Generated
        public @NonNull String toString() {
            return "KrystexVajramExecutor.KrystexVajramExecutorBuilder(vajramKryonGraph=" + String.valueOf(this.vajramKryonGraph) + ", executorConfig=" + String.valueOf(this.executorConfig) + ")";
        }
    }
}

