/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.testharness;

import com.flipkart.krystal.concurrent.SingleThreadExecutor;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValues;
import com.flipkart.krystal.data.ImmutableFacetValues;
import com.flipkart.krystal.data.ImmutableRequest;
import com.flipkart.krystal.krystex.caching.RequestLevelCache;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryondecoration.KryonDecoratorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutorConfig;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class VajramTestHarness {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Map<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValues, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object>>> vajramIdMockData;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KrystexVajramExecutorConfig kryonExecutorConfigBuilder;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestLevelCache requestLevelCache;

    @Inject
    public VajramTestHarness(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KrystexVajramExecutorConfig krystexVajramExecutorConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestLevelCache requestLevelCache) {
        this.kryonExecutorConfigBuilder = krystexVajramExecutorConfig;
        this.requestLevelCache = requestLevelCache;
        this.vajramIdMockData = new HashMap<String, Map<ImmutableFacetValues, Errable<Object>>>();
    }

    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramTestHarness prepareForTest(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KrystexVajramExecutorConfig executorConfig, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent RequestLevelCache requestLevelCache) {
        return new VajramTestHarness(executorConfig, requestLevelCache);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent VajramTestHarness withMock(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableFacetValues facets, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> response) {
        int index;
        String requestName = facets.getClass().getSimpleName();
        String vajramId = requestName.substring(0, index = requestName.lastIndexOf("_ImmutFac"));
        Map<ImmutableFacetValues, Errable<Object>> mockDataMap = this.vajramIdMockData.get(vajramId);
        if (Objects.isNull(mockDataMap)) {
            this.vajramIdMockData.put(vajramId, Map.of(facets, response));
        } else {
            Errable<Object> errable = mockDataMap.get((ImmutableRequest)facets);
            if (Objects.isNull(errable)) {
                mockDataMap.put(facets, response);
                this.vajramIdMockData.put(vajramId, mockDataMap);
            }
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent KrystexVajramExecutorConfig buildConfig() {
        this.vajramIdMockData.forEach((s, vajramRequestErrableMap) -> vajramRequestErrableMap.forEach((objectVajramRequest, objectErrable) -> this.requestLevelCache.primeCache(s, (FacetValues)objectVajramRequest, objectErrable.toFuture())));
        KryonExecutorConfig.KryonExecutorConfigBuilder configBuilder = this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().singleThreadExecutor(new SingleThreadExecutor("VajramTestHarness"));
        KryonDecoratorConfig kryonDecoratorConfig = (KryonDecoratorConfig)configBuilder.build().requestScopedKryonDecoratorConfigs().get(RequestLevelCache.DECORATOR_TYPE);
        if (kryonDecoratorConfig == null) {
            this.kryonExecutorConfigBuilder.kryonExecutorConfigBuilder().requestScopedKryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, new KryonDecoratorConfig(RequestLevelCache.DECORATOR_TYPE, executionContext -> this.vajramIdMockData.containsKey(executionContext.kryonId().value()), executionContext -> RequestLevelCache.DECORATOR_TYPE, kryonExecutionContext -> this.requestLevelCache));
        }
        return this.kryonExecutorConfigBuilder;
    }
}

