/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.except.StackTracelessException;
import com.flipkart.krystal.krystex.commands.Flush;
import com.flipkart.krystal.krystex.commands.ForwardBatch;
import com.flipkart.krystal.krystex.commands.ForwardGranule;
import com.flipkart.krystal.krystex.commands.KryonCommand;
import com.flipkart.krystal.krystex.kryon.Kryon;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonResponse;
import com.flipkart.krystal.krystex.request.RequestId;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.VajramInjectionProvider;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InjectingDecoratedKryon
implements Kryon<KryonCommand, KryonResponse> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = LoggerFactory.getLogger(InjectingDecoratedKryon.class);
    private final @UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon;
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @Nullable @UnknownKeyFor @Initialized VajramInjectionProvider injectionProvider;

    InjectingDecoratedKryon(@UnknownKeyFor @NonNull @Initialized Kryon<@UnknownKeyFor @NonNull @Initialized KryonCommand, @UnknownKeyFor @NonNull @Initialized KryonResponse> kryon, @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph, @Nullable @UnknownKeyFor @Initialized VajramInjectionProvider injectionProvider) {
        this.kryon = kryon;
        this.vajramKryonGraph = vajramKryonGraph;
        this.injectionProvider = injectionProvider;
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized Flush flushCommand) {
        this.kryon.executeCommand(flushCommand);
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinition getKryonDefinition() {
        return this.kryon.getKryonDefinition();
    }

    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> executeCommand(@UnknownKeyFor @NonNull @Initialized KryonCommand kryonCommand) {
        Optional<VajramDefinition> vajramDefinition = this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)kryonCommand.kryonId().value()));
        if (vajramDefinition.isPresent() && vajramDefinition.get().vajramMetadata().isInputInjectionNeeded()) {
            if (kryonCommand instanceof ForwardBatch) {
                ForwardBatch forwardBatch = (ForwardBatch)kryonCommand;
                return this.injectFacets(forwardBatch, vajramDefinition.get());
            }
            if (kryonCommand instanceof ForwardGranule) {
                UnsupportedOperationException e = new UnsupportedOperationException("KryonInputInjector does not support KryonExecStrategy GRANULAR. Please use BATCH instead");
                log.error("", (Throwable)e);
                throw e;
            }
        }
        return this.kryon.executeCommand(kryonCommand);
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized KryonResponse> injectFacets(@UnknownKeyFor @NonNull @Initialized ForwardBatch forwardBatch, @UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        ImmutableMap requestIdToFacets = forwardBatch.executableRequests();
        LinkedHashSet<String> newInputsNames = new LinkedHashSet<String>((Collection<String>)forwardBatch.inputNames());
        ImmutableMap.Builder newRequests = ImmutableMap.builder();
        LinkedHashSet<InputDef> injectableFacets = new LinkedHashSet<InputDef>();
        for (VajramFacetDefinition facetDefinition : vajramDefinition.getVajram().getFacetDefinitions()) {
            InputDef inputDef;
            if (!(facetDefinition instanceof InputDef) || !(inputDef = (InputDef)facetDefinition).sources().contains((Object)InputSource.SESSION)) continue;
            injectableFacets.add(inputDef);
        }
        for (InputDef injectableFacet : injectableFacets) {
            newInputsNames.add(injectableFacet.name());
        }
        LinkedHashMap<String, Errable<Object>> newInputsValues = new LinkedHashMap<String, Errable<Object>>();
        for (Map.Entry entry : requestIdToFacets.entrySet()) {
            RequestId requestId = (RequestId)entry.getKey();
            Facets facets = (Facets)entry.getValue();
            Facets newFacets = this.injectFacetsOfVajram(vajramDefinition, facets, newInputsValues);
            newRequests.put((Object)requestId, (Object)newFacets);
        }
        return this.kryon.executeCommand((KryonCommand)new ForwardBatch(forwardBatch.kryonId(), ImmutableSet.copyOf(newInputsNames), newRequests.build(), forwardBatch.dependantChain(), forwardBatch.skippedRequests()));
    }

    private @UnknownKeyFor @NonNull @Initialized Facets injectFacetsOfVajram(@UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition, @UnknownKeyFor @NonNull @Initialized Facets facets, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object>> newInputValues) {
        HashMap<String, Errable> newValues = new HashMap<String, Errable>();
        Vajram vajram = vajramDefinition.getVajram();
        ImmutableCollection facetDefinitions = vajram.getFacetDefinitions();
        for (VajramFacetDefinition facetDefinition : facetDefinitions) {
            String inputName = facetDefinition.name();
            if (!(facetDefinition instanceof InputDef)) continue;
            InputDef inputDef = (InputDef)facetDefinition;
            if (facets.getInputValue(inputName).value().isPresent() || !inputDef.sources().contains((Object)InputSource.SESSION)) continue;
            Errable value = newInputValues.computeIfAbsent(inputName, _i -> this.getInjectedValue(vajramDefinition.getVajram().getId(), inputDef));
            newValues.put(inputName, value);
        }
        if (!newValues.isEmpty()) {
            facets.values().forEach(newValues::putIfAbsent);
            return new Facets(newValues);
        }
        return facets;
    }

    private @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @NonNull @Initialized Object> getInjectedValue(@UnknownKeyFor @NonNull @Initialized VajramID vajramId, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InputDef<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputDef) {
        VajramInjectionProvider inputInjector = this.injectionProvider;
        if (inputInjector == null) {
            StackTracelessException exception = new StackTracelessException("Dependency injector is null");
            log.error("Cannot inject input {} of vajram {}", new Object[]{inputDef, this.kryon.getKryonDefinition().kryonId().value(), exception});
            return Errable.withError((Throwable)exception);
        }
        try {
            return inputInjector.get(vajramId, inputDef);
        }
        catch (Throwable e) {
            String message = "Could not inject input %s of vajram %s".formatted(inputDef, this.kryon.getKryonDefinition().kryonId().value());
            log.error(message, e);
            return Errable.withError((Throwable)e);
        }
    }
}

