/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutionConfig;
import com.flipkart.krystal.krystex.kryon.KryonExecutor;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramRequest;
import com.flipkart.krystal.vajram.exec.VajramExecutor;
import com.flipkart.krystal.vajram.facets.FacetValuesAdaptor;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KrystexVajramExecutor<@UnknownKeyFor C extends @UnknownKeyFor @NonNull @Initialized ApplicationRequestContext>
implements VajramExecutor<C> {
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final C applicationRequestContext;
    private final @UnknownKeyFor @NonNull @Initialized KrystalExecutor krystalExecutor;

    public KrystexVajramExecutor(@UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph, C applicationRequestContext, @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> executorServicePool, @UnknownKeyFor @NonNull @Initialized KryonExecutorConfig config) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.applicationRequestContext = applicationRequestContext;
        this.krystalExecutor = new KryonExecutor(vajramKryonGraph.getKryonDefinitionRegistry(), executorServicePool, config, applicationRequestContext.requestId());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T> execute(@UnknownKeyFor @NonNull @Initialized VajramID vajramId, @UnknownKeyFor @NonNull @Initialized Function<C, @UnknownKeyFor @NonNull @Initialized VajramRequest<T>> vajramRequestCreator) {
        return this.execute(vajramId, vajramRequestCreator, KryonExecutionConfig.builder().executionId("defaultExecution").build());
    }

    public <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T> execute(@UnknownKeyFor @NonNull @Initialized VajramID vajramId, @UnknownKeyFor @NonNull @Initialized Function<C, @UnknownKeyFor @NonNull @Initialized VajramRequest<T>> vajramRequestCreator, @UnknownKeyFor @NonNull @Initialized KryonExecutionConfig executionConfig) {
        return this.executeWithFacets(vajramId, vajramRequestCreator.andThen(FacetValuesAdaptor::toFacetValues), executionConfig);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T> executeWithFacets(@UnknownKeyFor @NonNull @Initialized VajramID vajramId, @UnknownKeyFor @NonNull @Initialized Function<C, @UnknownKeyFor @NonNull @Initialized Facets> facetsCreator, @UnknownKeyFor @NonNull @Initialized KryonExecutionConfig executionConfig) {
        return this.krystalExecutor.executeKryon(this.vajramKryonGraph.getKryonId(vajramId), facetsCreator.apply(this.applicationRequestContext), executionConfig);
    }

    public @UnknownKeyFor @NonNull @Initialized KrystalExecutor getKrystalExecutor() {
        return this.krystalExecutor;
    }

    public void flush() {
        this.krystalExecutor.flush();
    }

    public void close() {
        this.krystalExecutor.close();
    }
}

