/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.ForkJoinExecutorPool;
import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.logicdecoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecoratorConfig;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverLogicDefinition;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.MandatoryFacetsMissingException;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDefinitionException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLoader;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.VajramIndex;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.exec.VajramExecutableGraph;
import com.flipkart.krystal.vajram.facets.DependencyCommand;
import com.flipkart.krystal.vajram.facets.DependencyDef;
import com.flipkart.krystal.vajram.facets.InputDef;
import com.flipkart.krystal.vajram.facets.InputSource;
import com.flipkart.krystal.vajram.facets.MultiExecute;
import com.flipkart.krystal.vajram.facets.SingleExecute;
import com.flipkart.krystal.vajram.facets.VajramFacetDefinition;
import com.flipkart.krystal.vajram.facets.resolution.InputResolver;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverDefinition;
import com.flipkart.krystal.vajram.facets.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.facets.resolution.ResolutionRequest;
import com.flipkart.krystal.vajram.facets.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajramexecutor.krystex.InputBatcherConfig;
import com.flipkart.krystal.vajramexecutor.krystex.InputBatchingDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.LogicDefRegistryDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjector;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class VajramKryonGraph
implements VajramExecutableGraph {
    private final @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized LogicDefRegistryDecorator logicRegistryDecorator;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized KryonId> vajramExecutables = new LinkedHashMap<VajramID, KryonId>();
    private final @UnknownKeyFor @NonNull @Initialized VajramIndex vajramIndex = new VajramIndex();
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> sessionScopedDecoratorConfigs;
    private final @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering;
    private final @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> executorPool;
    @NotOnlyInitialized
    private final @UnknownKeyFor @NonNull @Initialized InputInjector inputInjector;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized VajramMetadata> vajramMetadataMap;

    private VajramKryonGraph(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] packagePrefixes, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> sessionScopedDecorators, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider, @UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore) {
        this.sessionScopedDecoratorConfigs = sessionScopedDecorators;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.executorPool = new ForkJoinExecutorPool(maxParallelismPerCore);
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.kryonDefinitionRegistry = new KryonDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistryDecorator = new LogicDefRegistryDecorator(logicDefinitionRegistry);
        for (String packagePrefix : packagePrefixes) {
            List vajrams = VajramLoader.loadVajramsFromClassPath((String)packagePrefix);
            vajrams.forEach(this::registerVajram);
        }
        this.inputInjector = new InputInjector(this, inputInjectionProvider);
        this.vajramMetadataMap = new HashMap<String, VajramMetadata>();
    }

    public @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> getExecutorPool() {
        return this.executorPool;
    }

    public <C extends ApplicationRequestContext> @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutor<C> createExecutor(C requestContext) {
        return this.createExecutor(requestContext, KryonExecutorConfig.builder().debug(false).build());
    }

    public <C extends ApplicationRequestContext> @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutor<C> createExecutor(C requestContext, @UnknownKeyFor @NonNull @Initialized KryonExecutorConfig krystexConfig) {
        if (this.logicDecorationOrdering != null && LogicDecorationOrdering.none().equals((Object)krystexConfig.logicDecorationOrdering())) {
            krystexConfig = krystexConfig.toBuilder().logicDecorationOrdering(this.logicDecorationOrdering).build();
        }
        return new KrystexVajramExecutor<C>(this, requestContext, this.executorPool, krystexConfig);
    }

    public void registerInputBatchers(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, InputBatcherConfig ... inputBatcherConfigs) {
        KryonId kryonId = this.getKryonId(vajramID);
        VajramDefinition vajramDefinition = this.vajramDefinitions.get(vajramID);
        OutputLogicDefinition outputLogicDefinition = this.kryonDefinitionRegistry.get(kryonId).getOutputLogicDefinition();
        if (kryonId == null || vajramDefinition == null) {
            throw new IllegalArgumentException("Unable to find vajram with id %s".formatted(vajramID));
        }
        Vajram vajram = vajramDefinition.getVajram();
        ArrayList<OutputLogicDecoratorConfig> outputLogicDecoratorConfigList = new ArrayList<OutputLogicDecoratorConfig>();
        for (InputBatcherConfig inputBatcherConfig : inputBatcherConfigs) {
            Predicate<LogicExecutionContext> biFunction = logicExecutionContext -> vajram.getFacetDefinitions().stream().filter(facetDefinition -> facetDefinition instanceof InputDef).map(facetDefinition -> (InputDef)facetDefinition).anyMatch(InputDef::isBatched) && inputBatcherConfig.shouldModulate().test((LogicExecutionContext)logicExecutionContext);
            outputLogicDecoratorConfigList.add(new OutputLogicDecoratorConfig(InputBatchingDecorator.DECORATOR_TYPE, biFunction, inputBatcherConfig.instanceIdGenerator(), decoratorContext -> inputBatcherConfig.decoratorFactory().apply(new InputBatcherConfig.BatcherContext((Vajram<?>)vajram, (OutputLogicDecoratorConfig.DecoratorContext)decoratorContext))));
        }
        outputLogicDefinition.registerRequestScopedDecorator(outputLogicDecoratorConfigList);
    }

    public @UnknownKeyFor @NonNull @Initialized DependantChain computeDependantChain(@UnknownKeyFor @NonNull @Initialized String firstVajramId, @UnknownKeyFor @NonNull @Initialized String firstDependencyName, String ... subsequentDependencyNames) {
        KryonId firstKryonId = this._getVajramExecutionGraph(VajramID.vajramID((String)firstVajramId));
        KryonDefinition currentKryon = this.kryonDefinitionRegistry.get(firstKryonId);
        DependantChain currentDepChain = this.kryonDefinitionRegistry.getDependantChainsStart().extend(firstKryonId, firstDependencyName);
        String previousDepName = firstDependencyName;
        for (String currentDepName : subsequentDependencyNames) {
            KryonId depKryonId = (KryonId)currentKryon.dependencyKryons().get((Object)previousDepName);
            if (depKryonId == null) {
                throw new IllegalStateException("Unable find kryon for dependency %s of kryon %s".formatted(currentDepName, currentKryon));
            }
            currentDepChain = currentDepChain.extend(depKryonId, currentDepName);
            currentKryon = this.kryonDefinitionRegistry.get(depKryonId);
            previousDepName = currentDepName;
        }
        return currentDepChain;
    }

    public void close() {
        this.executorPool.close();
    }

    private void registerVajram(@UnderInitialization VajramKryonGraph this, @UnknownKeyFor @NonNull @Initialized Vajram vajram) {
        if (this.vajramDefinitions.containsKey(vajram.getId())) {
            return;
        }
        this.vajramDefinitions.put(vajram.getId(), new VajramDefinition(vajram));
        this.vajramIndex.add(vajram);
    }

    @UnknownKeyFor @NonNull @Initialized KryonId getKryonId(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        return this._getVajramExecutionGraph(vajramId);
    }

    private @UnknownKeyFor @NonNull @Initialized KryonId _getVajramExecutionGraph(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        KryonId kryonId = this.vajramExecutables.get(vajramId);
        if (kryonId != null) {
            return kryonId;
        }
        kryonId = new KryonId(vajramId.vajramId());
        this.vajramExecutables.put(vajramId, kryonId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId).orElseThrow(() -> new NoSuchElementException("Could not find vajram with id: %s".formatted(vajramId)));
        this.vajramMetadataMap.put(vajramId.vajramId(), new VajramMetadata(vajramDefinition.getVajram()));
        InputResolverCreationResult inputResolverCreationResult = this.createKryonLogicsForInputResolvers(vajramDefinition);
        ImmutableMap<String, KryonId> depNameToProviderKryon = this.createKryonDefinitionsForDependencies(vajramDefinition);
        OutputLogicDefinition<?> outputLogicDefinition = this.createVajramKryonLogic(kryonId, vajramDefinition);
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.newKryonDefinition(kryonId.value(), outputLogicDefinition.kryonLogicId(), depNameToProviderKryon, inputResolverCreationResult.resolverDefinitions(), inputResolverCreationResult.multiResolver());
        return kryonDefinition.kryonId();
    }

    private @UnknownKeyFor @NonNull @Initialized InputResolverCreationResult createKryonLogicsForInputResolvers(@UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        Vajram vajram = vajramDefinition.getVajram();
        VajramID vajramId = vajram.getId();
        ImmutableCollection facetDefinitions = vajram.getFacetDefinitions();
        ArrayList inputResolvers = new ArrayList(vajramDefinition.getInputResolverDefinitions());
        ImmutableMap resolversByResolverDefs = (ImmutableMap)inputResolvers.stream().collect(ImmutableMap.toImmutableMap(inputResolverDefinition -> {
            String dependencyName = inputResolverDefinition.resolutionTarget().dependencyName();
            ImmutableSet resolvedInputNames = inputResolverDefinition.resolutionTarget().inputNames();
            ImmutableSet sources = inputResolverDefinition.sources();
            ImmutableCollection requiredInputs = (ImmutableCollection)facetDefinitions.stream().filter(def -> sources.contains((Object)def.name())).collect(ImmutableList.toImmutableList());
            ResolverLogicDefinition inputResolverLogic = this.logicRegistryDecorator.newResolverLogic(vajramId.vajramId(), "%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependencyName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)resolvedInputNames)), (Set<String>)sources, inputValues -> {
                Object dependencyCommand;
                this.validateMandatory(vajramId, inputValues, (ImmutableCollection<VajramFacetDefinition>)requiredInputs);
                try {
                    if (inputResolverDefinition instanceof SimpleInputResolver) {
                        SimpleInputResolver inputResolver = (SimpleInputResolver)inputResolverDefinition;
                        InputResolverUtil.ResolutionResult resolutionResult = InputResolverUtil.multiResolve(List.of(new ResolutionRequest(dependencyName, resolvedInputNames)), (Map)ImmutableMap.of((Object)dependencyName, (Object)ImmutableList.of((Object)inputResolver)), (Facets)inputValues);
                        dependencyCommand = resolutionResult.skippedDependencies().containsKey(dependencyName) ? (DependencyCommand)resolutionResult.skippedDependencies().get(dependencyName) : VajramKryonGraph.toDependencyCommand((List)resolutionResult.results().values().iterator().next());
                    } else if (inputResolverDefinition instanceof InputResolver) {
                        InputResolver inputResolver = (InputResolver)inputResolverDefinition;
                        dependencyCommand = inputResolver.resolve(dependencyName, resolvedInputNames, inputValues);
                    } else {
                        dependencyCommand = vajram.resolveInputOfDependency(dependencyName, resolvedInputNames, inputValues);
                    }
                }
                catch (Throwable t) {
                    dependencyCommand = SingleExecute.skipExecution((String)"Resolver threw exception: %s".formatted(Throwables.getStackTraceAsString((Throwable)t)));
                }
                return VajramKryonGraph.toResolverCommand(dependencyCommand);
            });
            return new ResolverDefinition(inputResolverLogic.kryonLogicId(), sources, dependencyName, resolvedInputNames);
        }, Function.identity()));
        MultiResolverDefinition multiResolverDefinition = this.logicRegistryDecorator.newMultiResolver(vajramId.vajramId(), vajramId.vajramId() + ":multiResolver", (Set)facetDefinitions.stream().map(VajramFacetDefinition::name).collect(ImmutableSet.toImmutableSet()), (resolutionRequests, inputs) -> {
            HashSet allResolverDefs = new HashSet();
            for (DependencyResolutionRequest resolutionRequest : resolutionRequests) {
                Set resolverDefinitions = resolutionRequest.resolverDefinitions();
                allResolverDefs.addAll(resolverDefinitions);
            }
            HashMap<String, List> simpleResolverDefsByDep = new HashMap<String, List>();
            ArrayList<ResolverDefinition> complexResolverDefs = new ArrayList<ResolverDefinition>();
            for (ResolverDefinition resolverDefinition : allResolverDefs) {
                if (resolversByResolverDefs.get((Object)resolverDefinition) instanceof SimpleInputResolver) {
                    simpleResolverDefsByDep.computeIfAbsent(resolverDefinition.dependencyName(), k -> new ArrayList()).add(resolverDefinition);
                    continue;
                }
                complexResolverDefs.add(resolverDefinition);
            }
            InputResolverUtil.ResolutionResult simpleResolutions = InputResolverUtil.multiResolve(simpleResolverDefsByDep.entrySet().stream().map(entry -> new ResolutionRequest((String)entry.getKey(), (ImmutableSet)((List)entry.getValue()).stream().map(ResolverDefinition::resolvedInputNames).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet()))).toList(), simpleResolverDefsByDep.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(def -> Optional.ofNullable((InputResolverDefinition)resolversByResolverDefs.get(def)).orElseThrow(() -> new AssertionError((Object)"Could not find resolver for resolver definition. This should not happen"))).map(ird -> (SimpleInputResolver)ird).toList())), (Facets)inputs);
            @Nullable Map results = simpleResolutions.results();
            Map skippedDependencies = simpleResolutions.skippedDependencies();
            LinkedHashMap resolverCommands = new LinkedHashMap();
            for (ResolverDefinition resolverDef : complexResolverDefs) {
                DependencyCommand command2;
                String dependencyName = resolverDef.dependencyName();
                if (skippedDependencies.containsKey(dependencyName)) continue;
                ImmutableSet resolvables = resolverDef.resolvedInputNames();
                try {
                    Object patt22977$temp = resolversByResolverDefs.get((Object)resolverDef);
                    if (patt22977$temp instanceof InputResolver) {
                        InputResolver inputResolver = (InputResolver)patt22977$temp;
                        command2 = inputResolver.resolve(dependencyName, resolvables, inputs);
                    } else {
                        command2 = vajram.resolveInputOfDependency(dependencyName, resolvables, inputs);
                    }
                }
                catch (Throwable e2) {
                    command2 = SingleExecute.skipExecution((String)String.format("Got exception %s while executing the resolver of the dependency %s", e2, dependencyName));
                }
                if (command2.shouldSkip()) {
                    skippedDependencies.put(dependencyName, command2);
                    results.remove(dependencyName);
                    continue;
                }
                InputResolverUtil.collectDepInputs((List)results.computeIfAbsent(dependencyName, _k -> new ArrayList()), null, (DependencyCommand)command2);
            }
            results.forEach((key, value) -> resolverCommands.put(key, VajramKryonGraph.toResolverCommand(VajramKryonGraph.toDependencyCommand(value))));
            skippedDependencies.forEach((depName, command) -> resolverCommands.put(depName, ResolverCommand.skip((String)command.doc())));
            return ImmutableMap.copyOf(resolverCommands);
        });
        return new InputResolverCreationResult((ImmutableList<ResolverDefinition>)ImmutableList.copyOf((Collection)resolversByResolverDefs.keySet()), multiResolverDefinition.kryonLogicId());
    }

    private static @UnknownKeyFor @NonNull @Initialized ResolverCommand toResolverCommand(@UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Facets> dependencyCommand) {
        if (dependencyCommand.shouldSkip()) {
            return ResolverCommand.skip((String)dependencyCommand.doc());
        }
        return ResolverCommand.multiExecuteWith((ImmutableList)((ImmutableList)dependencyCommand.inputs().stream().filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList())));
    }

    private void validateMandatory(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, @UnknownKeyFor @NonNull @Initialized Facets facets, @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized VajramFacetDefinition> requiredInputs) {
        Iterable mandatoryInputs = requiredInputs.stream().filter(facetDefinition -> facetDefinition instanceof InputDef).filter(VajramFacetDefinition::isMandatory)::iterator;
        HashMap<String, Throwable> missingMandatoryValues = new HashMap<String, Throwable>();
        for (VajramFacetDefinition mandatoryInput : mandatoryInputs) {
            Errable value = facets.getInputValue(mandatoryInput.name());
            if (!value.error().isPresent() && !value.value().isEmpty()) continue;
            missingMandatoryValues.put(mandatoryInput.name(), value.error().orElse(new NoSuchElementException("No value present for input %s".formatted(mandatoryInput.name()))));
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryFacetsMissingException(vajramID, missingMandatoryValues);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createVajramKryonLogic(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        VajramID vajramId = vajramDefinition.getVajram().getId();
        ImmutableCollection facetDefinitions = vajramDefinition.getVajram().getFacetDefinitions();
        ImmutableSet inputNames = (ImmutableSet)facetDefinitions.stream().filter(this::isVisibleToKrystex).map(VajramFacetDefinition::name).collect(ImmutableSet.toImmutableSet());
        KryonLogicId outputLogicName = new KryonLogicId(kryonId, "%s:outputLogic".formatted(vajramId));
        OutputLogicDefinition outputLogic = this.logicRegistryDecorator.newOutputLogic(vajramDefinition.getVajram() instanceof IOVajram, outputLogicName, (Set<String>)inputNames, inputsList -> {
            ArrayList validInputs = new ArrayList();
            LinkedHashMap<K, @Nullable V> failedValidations = new LinkedHashMap();
            inputsList.forEach(inputs -> {
                try {
                    this.validateMandatory(vajramId, (Facets)inputs, (ImmutableCollection<VajramFacetDefinition>)facetDefinitions);
                    validInputs.add(inputs);
                }
                catch (Throwable e) {
                    failedValidations.put(inputs, CompletableFuture.failedFuture(e));
                }
            });
            Vajram vajram = vajramDefinition.getVajram();
            @Nullable ImmutableMap validResults = vajram.execute(ImmutableList.copyOf(validInputs));
            return ImmutableMap.builder().putAll((Map)validResults).putAll(failedValidations).build();
        }, (ImmutableMap<Object, Tag>)ImmutableMap.copyOf((Map)vajramDefinition.getOutputLogicTags()));
        this.registerInputInjector(outputLogic, vajramDefinition.getVajram());
        this.sessionScopedDecoratorConfigs.values().forEach(arg_0 -> outputLogic.registerSessionScopedLogicDecorator(arg_0));
        return outputLogic;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVisibleToKrystex(@UnknownKeyFor @NonNull @Initialized VajramFacetDefinition vajramFacetDefinition) {
        if (vajramFacetDefinition instanceof InputDef) {
            InputDef inputDef = (InputDef)vajramFacetDefinition;
            return inputDef.sources().contains((Object)InputSource.CLIENT);
        }
        return true;
    }

    private <T> void registerInputInjector(@UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<T> logicDefinition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        VajramMetadata metadata = this.vajramMetadataMap.get(vajram.getId().vajramId());
        if (metadata == null || !metadata.isInputInjectionNeeded()) {
            return;
        }
        logicDefinition.registerSessionScopedLogicDecorator(new OutputLogicDecoratorConfig(InputInjector.DECORATOR_TYPE, logicExecutionContext -> true, logicExecutionContext -> logicExecutionContext.kryonId().value(), decoratorContext -> this.inputInjector));
    }

    private static @UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Facets> toDependencyCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>> depInputs) {
        MultiExecute dependencyCommand;
        if (depInputs.isEmpty()) {
            dependencyCommand = MultiExecute.executeFanoutWith((Collection)ImmutableList.of());
        } else if (depInputs.size() == 1) {
            Map<String, FacetValue> collect = depInputs.get(0).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Errable.withValue(e.getValue())));
            dependencyCommand = SingleExecute.executeWith((Object)new Facets(collect));
        } else {
            ArrayList<Facets> facetsList = new ArrayList<Facets>();
            for (Map<String, Object> depInput : depInputs) {
                facetsList.add(new Facets(depInput.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Errable.withValue(e.getValue())))));
            }
            dependencyCommand = MultiExecute.executeFanoutWith(facetsList);
        }
        return dependencyCommand;
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> createKryonDefinitionsForDependencies(@UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        ArrayList<DependencyDef> dependencies = new ArrayList<DependencyDef>();
        for (VajramFacetDefinition vajramFacetDefinition : vajramDefinition.getVajram().getFacetDefinitions()) {
            if (!(vajramFacetDefinition instanceof DependencyDef)) continue;
            DependencyDef definition = (DependencyDef)vajramFacetDefinition;
            dependencies.add(definition);
        }
        HashMap<String, KryonId> depNameToProviderKryon = new HashMap<String, KryonId>();
        for (DependencyDef dependencyDef : dependencies) {
            DataAccessSpec accessSpec = dependencyDef.dataAccessSpec();
            String dependencyName = dependencyDef.name();
            AccessSpecMatchingResult accessSpecMatchingResult = this.vajramIndex.getVajrams(accessSpec);
            if (accessSpecMatchingResult.hasUnsuccessfulMatches()) {
                throw new VajramDefinitionException("Unable to find vajrams for accessSpecs %s".formatted(accessSpecMatchingResult.unsuccessfulMatches()));
            }
            ImmutableMap dependencyVajrams = accessSpecMatchingResult.successfulMatches();
            if (dependencyVajrams.size() > 1) {
                throw new UnsupportedOperationException("");
            }
            Vajram dependencyVajram = (Vajram)dependencyVajrams.values().iterator().next();
            depNameToProviderKryon.put(dependencyName, this._getVajramExecutionGraph(dependencyVajram.getId()));
        }
        return ImmutableMap.copyOf(depNameToProviderKryon);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized VajramDefinition> getVajramDefinition(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        return Optional.ofNullable(this.vajramDefinitions.get(vajramId));
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry getKryonDefinitionRegistry() {
        return this.kryonDefinitionRegistry;
    }

    private record VajramMetadata(@UnknownKeyFor @NonNull @Initialized boolean isInputInjectionNeeded) {
        public VajramMetadata(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
            this(vajram.getFacetDefinitions().stream().filter(facetDefinition -> facetDefinition instanceof InputDef).map(facetDefinition -> (InputDef)facetDefinition).anyMatch(input -> input.sources() != null && input.sources().contains((Object)InputSource.SESSION)));
        }
    }

    private record InputResolverCreationResult(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized KryonLogicId multiResolver) {
    }

    public static final class Builder {
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> packagePrefixes = new LinkedHashSet<String>();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig> sessionScopedDecoratorConfigs = new HashMap<String, OutputLogicDecoratorConfig>();
        private @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering = new LogicDecorationOrdering(ImmutableSet.of());
        private @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider;
        private @UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore = 1.0;

        public @UnknownKeyFor @NonNull @Initialized Builder loadFromPackage(@UnknownKeyFor @NonNull @Initialized String packagePrefix) {
            this.packagePrefixes.add(packagePrefix);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder decorateOutputLogicForSession(@UnknownKeyFor @NonNull @Initialized OutputLogicDecoratorConfig logicDecoratorConfig) {
            if (this.sessionScopedDecoratorConfigs.putIfAbsent(logicDecoratorConfig.decoratorType(), logicDecoratorConfig) != null) {
                throw new IllegalArgumentException("Cannot have two decorator configs for same decorator type : %s".formatted(logicDecoratorConfig.decoratorType()));
            }
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder maxParallelismPerCore(@UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore) {
            this.maxParallelismPerCore = maxParallelismPerCore;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder logicDecorationOrdering(@UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering) {
            this.logicDecorationOrdering = logicDecorationOrdering;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder injectInputsWith(@UnknownKeyFor @NonNull @Initialized InputInjectionProvider inputInjectionProvider) {
            this.inputInjectionProvider = inputInjectionProvider;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized VajramKryonGraph build() {
            return new VajramKryonGraph((String[])this.packagePrefixes.toArray(String[]::new), (ImmutableMap<String, OutputLogicDecoratorConfig>)ImmutableMap.copyOf(this.sessionScopedDecoratorConfigs), this.logicDecorationOrdering, this.inputInjectionProvider, this.maxParallelismPerCore);
        }
    }
}

