/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.Facets;
import com.flipkart.krystal.krystex.OutputLogic;
import com.flipkart.krystal.krystex.OutputLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.logicdecoration.OutputLogicDecorator;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.vajram.facets.FacetValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.FacetsConverter;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.ModulatedFacets;
import com.flipkart.krystal.vajram.modulation.UnmodulatedFacets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputModulationDecorator<@UnknownKeyFor I extends @UnknownKeyFor @NonNull @Initialized FacetValuesAdaptor, @UnknownKeyFor C extends @UnknownKeyFor @NonNull @Initialized FacetValuesAdaptor>
implements OutputLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = InputModulationDecorator.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized InputModulator<I, C> inputModulator;
    private final @UnknownKeyFor @NonNull @Initialized FacetsConverter<I, C> facetsConverter;
    private final @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Facets, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> futureCache = new HashMap<Facets, CompletableFuture<Object>>();
    private @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized DependantChain> activeDependantChains = ImmutableSet.of();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChains = new LinkedHashSet<DependantChain>();

    public InputModulationDecorator(@UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized InputModulator<I, C> inputModulator, @UnknownKeyFor @NonNull @Initialized FacetsConverter<I, C> facetsConverter, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputModulator = inputModulator;
        this.facetsConverter = facetsConverter;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public @UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized OutputLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        this.inputModulator.onModulation(requests -> requests.forEach(request -> this.modulateInputsList(logicToDecorate, (ModulatedFacets<I, C>)request)));
        return inputsList -> {
            List<C> requests = inputsList.stream().map(this.facetsConverter).toList();
            List modulatedFacets = requests.stream().map(unmodulatedInput -> this.inputModulator.add((Object)unmodulatedInput.modulatedInputs(), (Object)unmodulatedInput.commonFacets())).flatMap(Collection::stream).toList();
            requests.forEach(request -> this.futureCache.computeIfAbsent(request.toFacetValues(), e -> new CompletableFuture()));
            for (ModulatedFacets modulatedFacet : modulatedFacets) {
                this.modulateInputsList(logicToDecorate, modulatedFacet);
            }
            return (ImmutableMap)requests.stream().map(UnmodulatedFacets::toFacetValues).collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Optional.ofNullable(this.futureCache.get(key)).orElseThrow(() -> new AssertionError((Object)"Future cache has been primed with values. This should never happen"))));
        };
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependantChain> allActiveDepChains = new LinkedHashSet<DependantChain>((Collection<DependantChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependantChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependantChains.add(flushCommand.dependantsChain());
            if (this.flushedDependantChains.containsAll((Collection<?>)this.activeDependantChains)) {
                this.inputModulator.modulate();
                this.flushedDependantChains.clear();
            }
        }
    }

    private void modulateInputsList(@UnknownKeyFor @NonNull @Initialized OutputLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized ModulatedFacets<I, C> modulatedFacets) {
        ImmutableList requests = (ImmutableList)modulatedFacets.modInputs().stream().map(each -> new UnmodulatedFacets(each, (FacetValuesAdaptor)modulatedFacets.commonFacets())).collect(ImmutableList.toImmutableList());
        logicToDecorate.execute((ImmutableList)requests.stream().map(UnmodulatedFacets::toFacetValues).collect(ImmutableList.toImmutableList())).forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent((Facets)inputs, request -> new CompletableFuture())));
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.inputModulator.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_modulation.%s.", this.instanceId), configProvider));
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.instanceId;
    }
}

