/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.logicdecoration.FlushCommand;
import com.flipkart.krystal.krystex.logicdecoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.logicdecoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.logicdecoration.MainLogicDecorator;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.vajram.facets.InputValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputModulationDecorator<@UnknownKeyFor I extends @UnknownKeyFor @NonNull @Initialized InputValuesAdaptor, @UnknownKeyFor C extends @UnknownKeyFor @NonNull @Initialized InputValuesAdaptor>
implements MainLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = InputModulationDecorator.class.getName();
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized InputModulator<I, C> inputModulator;
    private final @UnknownKeyFor @NonNull @Initialized InputsConverter<I, C> inputsConverter;
    private final @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Inputs, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable @UnknownKeyFor @Initialized Object>> futureCache = new HashMap<Inputs, CompletableFuture<Object>>();
    private @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized DependantChain> activeDependantChains = ImmutableSet.of();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized DependantChain> flushedDependantChains = new LinkedHashSet<DependantChain>();

    public InputModulationDecorator(@UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized InputModulator<I, C> inputModulator, @UnknownKeyFor @NonNull @Initialized InputsConverter<I, C> inputsConverter, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized DependantChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputModulator = inputModulator;
        this.inputsConverter = inputsConverter;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public @UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        this.inputModulator.onModulation(requests -> requests.forEach(request -> this.modulateInputsList(logicToDecorate, (ModulatedInput<I, C>)request)));
        return inputsList -> {
            List<C> requests = inputsList.stream().map(this.inputsConverter).toList();
            List modulatedInputs = requests.stream().map(unmodulatedInput -> this.inputModulator.add((Object)unmodulatedInput.inputsNeedingModulation(), (Object)unmodulatedInput.commonInputs())).flatMap(Collection::stream).toList();
            requests.forEach(request -> this.futureCache.computeIfAbsent(request.toInputValues(), e -> new CompletableFuture()));
            for (ModulatedInput modulatedInput : modulatedInputs) {
                this.modulateInputsList(logicToDecorate, modulatedInput);
            }
            return (ImmutableMap)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableMap.toImmutableMap(Function.identity(), key -> Optional.ofNullable(this.futureCache.get(key)).orElseThrow(() -> new AssertionError((Object)"Future cache has been primed with values. This should never happen"))));
        };
    }

    public void executeCommand(@UnknownKeyFor @NonNull @Initialized LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependantChain> allActiveDepChains = new LinkedHashSet<DependantChain>((Collection<DependantChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependantChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependantChains.add(flushCommand.dependantsChain());
            if (this.flushedDependantChains.containsAll((Collection<?>)this.activeDependantChains)) {
                this.inputModulator.modulate();
                this.flushedDependantChains.clear();
            }
        }
    }

    private void modulateInputsList(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized ModulatedInput<I, C> modulatedInput) {
        ImmutableList requests = (ImmutableList)modulatedInput.modInputs().stream().map(each -> new UnmodulatedInput(each, (InputValuesAdaptor)modulatedInput.commonInputs())).collect(ImmutableList.toImmutableList());
        logicToDecorate.execute((ImmutableList)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableList.toImmutableList())).forEach((inputs, resultFuture) -> Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)this.futureCache.computeIfAbsent((Inputs)inputs, request -> new CompletableFuture())));
    }

    public void onConfigUpdate(@UnknownKeyFor @NonNull @Initialized ConfigProvider configProvider) {
        this.inputModulator.onConfigUpdate((ConfigProvider)new NestedConfig(String.format("input_modulation.%s.", this.instanceId), configProvider));
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return this.instanceId;
    }
}

