/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.JavaDataType;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class InputInjector
implements MainLogicDecorator {
    public static final @UnknownKeyFor @NonNull @Initialized String DECORATOR_TYPE = InputInjector.class.getName();
    public static final @UnknownKeyFor @NonNull @Initialized String INJECT_NAMED_KEY = "inject.named";
    @NotOnlyInitialized
    private final @UnknownKeyFor @NonNull @Initialized VajramKryonGraph vajramKryonGraph;
    private final @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider;

    public InputInjector(@UnderInitialization @UnknownKeyFor @NonNull VajramKryonGraph vajramKryonGraph, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider) {
        this.vajramKryonGraph = vajramKryonGraph;
        this.inputInjectionProvider = inputInjectionProvider;
    }

    public @UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> decorateLogic(@UnknownKeyFor @NonNull @Initialized MainLogic<@UnknownKeyFor @NonNull @Initialized Object> logicToDecorate, @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @NonNull @Initialized Object> originalLogicDefinition) {
        return inputsList -> {
            HashMap newInputsToOldInputs = new HashMap();
            ImmutableList inputValues = (ImmutableList)inputsList.stream().map(inputs -> {
                Inputs newInputs = this.injectFromSession(this.vajramKryonGraph.getVajramDefinition(VajramID.vajramID((String)Optional.ofNullable(originalLogicDefinition.kryonLogicId()).map(KryonLogicId::kryonId).map(KryonId::value).orElse(""))).orElse(null), (Inputs)inputs);
                newInputsToOldInputs.put(newInputs, inputs);
                return newInputs;
            }).collect(ImmutableList.toImmutableList());
            @Nullable ImmutableMap result = logicToDecorate.execute(inputValues);
            return (ImmutableMap)result.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> newInputsToOldInputs.getOrDefault(e.getKey(), (Inputs)e.getKey()), Map.Entry::getValue));
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String getId() {
        return InputInjector.class.getName();
    }

    private @UnknownKeyFor @NonNull @Initialized Inputs injectFromSession(@Nullable @UnknownKeyFor @Initialized VajramDefinition vajramDefinition, @UnknownKeyFor @NonNull @Initialized Inputs inputs) {
        HashMap newValues = new HashMap();
        Optional.ofNullable(vajramDefinition).map(VajramDefinition::getVajram).map(Vajram::getInputDefinitions).ifPresent(inputDefinitions -> {
            for (VajramInputDefinition inputDefinition : inputDefinitions) {
                ValueOrError<Object> value;
                String inputName = inputDefinition.name();
                if (!(inputDefinition instanceof Input)) continue;
                Input input = (Input)inputDefinition;
                if (input.sources().contains((Object)InputSource.CLIENT)) {
                    value = inputs.getInputValue(inputName);
                    if (!ValueOrError.empty().equals((Object)value)) continue;
                }
                if (!input.sources().contains((Object)InputSource.SESSION) || !(input.type() instanceof JavaDataType)) continue;
                value = this.getFromInjectionAdaptor((JavaDataType)input.type(), Optional.ofNullable(input.tags()).map(tags -> (Tag)tags.get((Object)INJECT_NAMED_KEY)).map(Tag::tagValue).orElse(null));
                newValues.put(inputName, value);
            }
        });
        if (!newValues.isEmpty()) {
            inputs.values().forEach(newValues::putIfAbsent);
            return new Inputs(newValues);
        }
        return inputs;
    }

    private @UnknownKeyFor @NonNull @Initialized ValueOrError<@UnknownKeyFor @NonNull @Initialized Object> getFromInjectionAdaptor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized JavaDataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dataType, @Nullable @UnknownKeyFor @Initialized String injectionName) {
        if (this.inputInjectionProvider == null) {
            return ValueOrError.withError((Throwable)new Exception("Dependency injector is null, cannot resolve SESSION input"));
        }
        if (dataType == null || dataType.javaType().isEmpty()) {
            return ValueOrError.withError((Throwable)new Exception("Data type not found"));
        }
        Optional type = dataType.javaType();
        Object resolvedObject = null;
        if (type.isPresent()) {
            if (injectionName != null) {
                resolvedObject = this.inputInjectionProvider.getInstance((Class)type.get(), injectionName);
            }
            if (resolvedObject == null) {
                resolvedObject = this.inputInjectionProvider.getInstance((Class)type.get());
            }
        }
        return ValueOrError.withValue(resolvedObject);
    }
}

