/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.ForkJoinExecutorPool;
import com.flipkart.krystal.krystex.LogicDefinitionRegistry;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.kryon.DependantChain;
import com.flipkart.krystal.krystex.kryon.KryonDefinition;
import com.flipkart.krystal.krystex.kryon.KryonDefinitionRegistry;
import com.flipkart.krystal.krystex.kryon.KryonExecutorConfig;
import com.flipkart.krystal.krystex.kryon.KryonId;
import com.flipkart.krystal.krystex.kryon.KryonLogicId;
import com.flipkart.krystal.krystex.resolution.DependencyResolutionRequest;
import com.flipkart.krystal.krystex.resolution.MultiResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverCommand;
import com.flipkart.krystal.krystex.resolution.ResolverDefinition;
import com.flipkart.krystal.krystex.resolution.ResolverLogicDefinition;
import com.flipkart.krystal.utils.MultiLeasePool;
import com.flipkart.krystal.vajram.ApplicationRequestContext;
import com.flipkart.krystal.vajram.IOVajram;
import com.flipkart.krystal.vajram.MandatoryInputsMissingException;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramDefinitionException;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.VajramLoader;
import com.flipkart.krystal.vajram.das.AccessSpecMatchingResult;
import com.flipkart.krystal.vajram.das.DataAccessSpec;
import com.flipkart.krystal.vajram.das.VajramIndex;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.exec.VajramExecutableGraph;
import com.flipkart.krystal.vajram.inputs.Dependency;
import com.flipkart.krystal.vajram.inputs.DependencyCommand;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.MultiExecute;
import com.flipkart.krystal.vajram.inputs.SingleExecute;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolver;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverDefinition;
import com.flipkart.krystal.vajram.inputs.resolution.InputResolverUtil;
import com.flipkart.krystal.vajram.inputs.resolution.ResolutionRequest;
import com.flipkart.krystal.vajram.inputs.resolution.SimpleInputResolver;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulationDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulatorConfig;
import com.flipkart.krystal.vajramexecutor.krystex.KrystexVajramExecutor;
import com.flipkart.krystal.vajramexecutor.krystex.LogicDefRegistryDecorator;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjector;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class VajramKryonGraph
implements VajramExecutableGraph {
    private final @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry kryonDefinitionRegistry;
    private final @UnknownKeyFor @NonNull @Initialized LogicDefRegistryDecorator logicRegistryDecorator;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized VajramDefinition> vajramDefinitions = new LinkedHashMap<VajramID, VajramDefinition>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized VajramID, @UnknownKeyFor @NonNull @Initialized KryonId> vajramExecutables = new LinkedHashMap<VajramID, KryonId>();
    private final @UnknownKeyFor @NonNull @Initialized VajramIndex vajramIndex = new VajramIndex();
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> sessionScopedDecoratorConfigs;
    private final @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering;
    private final @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> executorPool;
    @NotOnlyInitialized
    private final @UnknownKeyFor @NonNull @Initialized InputInjector inputInjector;

    private VajramKryonGraph(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] packagePrefixes, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> sessionScopedDecorators, @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering, @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider, @UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore) {
        this.sessionScopedDecoratorConfigs = sessionScopedDecorators;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.executorPool = new ForkJoinExecutorPool(maxParallelismPerCore);
        LogicDefinitionRegistry logicDefinitionRegistry = new LogicDefinitionRegistry();
        this.kryonDefinitionRegistry = new KryonDefinitionRegistry(logicDefinitionRegistry);
        this.logicRegistryDecorator = new LogicDefRegistryDecorator(logicDefinitionRegistry);
        for (String packagePrefix : packagePrefixes) {
            VajramLoader.loadVajramsFromClassPath((String)packagePrefix).forEach(this::registerVajram);
        }
        this.inputInjector = new InputInjector(this, inputInjectionProvider);
    }

    public @UnknownKeyFor @NonNull @Initialized MultiLeasePool<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ExecutorService> getExecutorPool() {
        return this.executorPool;
    }

    public <C extends ApplicationRequestContext> @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutor<C> createExecutor(C requestContext) {
        return this.createExecutor(requestContext, KryonExecutorConfig.builder().debug(false).build());
    }

    public <C extends ApplicationRequestContext> @UnknownKeyFor @NonNull @Initialized KrystexVajramExecutor<C> createExecutor(C requestContext, @UnknownKeyFor @NonNull @Initialized KryonExecutorConfig krystexConfig) {
        if (this.logicDecorationOrdering != null && LogicDecorationOrdering.none().equals((Object)krystexConfig.logicDecorationOrdering())) {
            krystexConfig = krystexConfig.toBuilder().logicDecorationOrdering(this.logicDecorationOrdering).build();
        }
        return new KrystexVajramExecutor<C>(this, requestContext, this.executorPool, krystexConfig);
    }

    public void registerInputModulators(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, InputModulatorConfig ... inputModulators) {
        KryonId kryonId = this.getKryonId(vajramID);
        VajramDefinition vajramDefinition = this.vajramDefinitions.get(vajramID);
        MainLogicDefinition mainLogicDefinition = this.kryonDefinitionRegistry.get(kryonId).getMainLogicDefinition();
        if (kryonId == null || vajramDefinition == null) {
            throw new IllegalArgumentException("Unable to find vajram with id %s".formatted(vajramID));
        }
        Vajram vajram = vajramDefinition.getVajram();
        ArrayList<MainLogicDecoratorConfig> mainLogicDecoratorConfigList = new ArrayList<MainLogicDecoratorConfig>();
        for (InputModulatorConfig inputModulatorConfig : inputModulators) {
            Predicate<LogicExecutionContext> biFunction = logicExecutionContext -> {
                for (VajramInputDefinition inputDefinition : vajram.getInputDefinitions()) {
                    Input definition;
                    if (!(inputDefinition instanceof Input) || !(definition = (Input)inputDefinition).needsModulation()) continue;
                    return inputModulatorConfig.shouldModulate().test((LogicExecutionContext)logicExecutionContext);
                }
                return false;
            };
            mainLogicDecoratorConfigList.add(new MainLogicDecoratorConfig(InputModulationDecorator.DECORATOR_TYPE, biFunction, inputModulatorConfig.instanceIdGenerator(), decoratorContext -> inputModulatorConfig.decoratorFactory().apply(new InputModulatorConfig.ModulatorContext((Vajram<?>)vajram, (MainLogicDecoratorConfig.DecoratorContext)decoratorContext))));
        }
        mainLogicDefinition.registerRequestScopedDecorator(mainLogicDecoratorConfigList);
    }

    public @UnknownKeyFor @NonNull @Initialized DependantChain computeDependantChain(@UnknownKeyFor @NonNull @Initialized String firstVajramId, @UnknownKeyFor @NonNull @Initialized String firstDependencyName, String ... subsequentDependencyNames) {
        KryonId firstKryonId = this._getVajramExecutionGraph(VajramID.vajramID((String)firstVajramId));
        KryonDefinition currentKryon = this.kryonDefinitionRegistry.get(firstKryonId);
        DependantChain currentDepChain = this.kryonDefinitionRegistry.getDependantChainsStart().extend(firstKryonId, firstDependencyName);
        String previousDepName = firstDependencyName;
        for (String currentDepName : subsequentDependencyNames) {
            KryonId depKryonId = (KryonId)currentKryon.dependencyKryons().get((Object)previousDepName);
            if (depKryonId == null) {
                throw new IllegalStateException("Unable find kryon for dependency %s of kryon %s".formatted(currentDepName, currentKryon));
            }
            currentDepChain = currentDepChain.extend(depKryonId, currentDepName);
            currentKryon = this.kryonDefinitionRegistry.get(depKryonId);
            previousDepName = currentDepName;
        }
        return currentDepChain;
    }

    public void close() {
        this.executorPool.close();
    }

    private void registerVajram(@UnderInitialization VajramKryonGraph this, @UnknownKeyFor @NonNull @Initialized Vajram vajram) {
        if (this.vajramDefinitions.containsKey(vajram.getId())) {
            return;
        }
        this.vajramDefinitions.put(vajram.getId(), new VajramDefinition(vajram));
        this.vajramIndex.add(vajram);
    }

    @UnknownKeyFor @NonNull @Initialized KryonId getKryonId(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        return this._getVajramExecutionGraph(vajramId);
    }

    private @UnknownKeyFor @NonNull @Initialized KryonId _getVajramExecutionGraph(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        KryonId kryonId = this.vajramExecutables.get(vajramId);
        if (kryonId != null) {
            return kryonId;
        }
        kryonId = new KryonId(vajramId.vajramId());
        this.vajramExecutables.put(vajramId, kryonId);
        VajramDefinition vajramDefinition = this.getVajramDefinition(vajramId).orElseThrow(() -> new NoSuchElementException("Could not find vajram with id: %s".formatted(vajramId)));
        InputResolverCreationResult inputResolverCreationResult = this.createKryonLogicsForInputResolvers(vajramDefinition);
        ImmutableMap<String, KryonId> depNameToProviderKryon = this.createKryonDefinitionsForDependencies(vajramDefinition);
        MainLogicDefinition<?> vajramLogicMainLogicDefinition = this.createVajramKryonLogic(kryonId, vajramDefinition);
        KryonDefinition kryonDefinition = this.kryonDefinitionRegistry.newKryonDefinition(kryonId.value(), vajramLogicMainLogicDefinition.kryonLogicId(), depNameToProviderKryon, inputResolverCreationResult.resolverDefinitions(), inputResolverCreationResult.multiResolver());
        return kryonDefinition.kryonId();
    }

    private @UnknownKeyFor @NonNull @Initialized InputResolverCreationResult createKryonLogicsForInputResolvers(@UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        Vajram vajram = vajramDefinition.getVajram();
        VajramID vajramId = vajram.getId();
        ImmutableCollection inputDefinitions = vajram.getInputDefinitions();
        ArrayList inputResolvers = new ArrayList(vajramDefinition.getInputResolverDefinitions());
        LinkedHashMap resolversByResolverDefs = new LinkedHashMap();
        inputResolvers.forEach(inputResolverDefinition -> resolversByResolverDefs.put(this.getResolverDefinition((Vajram<?>)vajram, vajramId, (ImmutableCollection<VajramInputDefinition>)inputDefinitions, (InputResolverDefinition)inputResolverDefinition), inputResolverDefinition));
        MultiResolverDefinition multiResolverDefinition = this.logicRegistryDecorator.newMultiResolver(vajramId.vajramId(), vajramId.vajramId() + ":multiResolver", (Set)inputDefinitions.stream().map(VajramInputDefinition::name).collect(ImmutableSet.toImmutableSet()), (resolutionRequests, inputs) -> {
            HashSet allResolverDefs = new HashSet();
            for (DependencyResolutionRequest dependencyResolutionRequest : resolutionRequests) {
                Set resolverDefinitions = dependencyResolutionRequest.resolverDefinitions();
                allResolverDefs.addAll(resolverDefinitions);
            }
            HashMap<String, List<ResolverDefinition>> simpleResolverDefsByDep = new HashMap<String, List<ResolverDefinition>>();
            ArrayList<Object> complexResolverDefs = new ArrayList<Object>();
            for (Object resolverDefinition2 : allResolverDefs) {
                if (resolversByResolverDefs.get(resolverDefinition2) instanceof SimpleInputResolver) {
                    simpleResolverDefsByDep.computeIfAbsent(resolverDefinition2.dependencyName(), k -> new ArrayList()).add(resolverDefinition2);
                    continue;
                }
                complexResolverDefs.add(resolverDefinition2);
            }
            ArrayList<ResolutionRequest> result = new ArrayList<ResolutionRequest>();
            for (Map.Entry entry : simpleResolverDefsByDep.entrySet()) {
                HashSet resolvedInputNames = new HashSet();
                ((List)entry.getValue()).forEach(resolverDefinition -> resolvedInputNames.addAll(resolverDefinition.resolvedInputNames()));
                ResolutionRequest resolutionRequest = new ResolutionRequest((String)entry.getKey(), ImmutableSet.copyOf(resolvedInputNames));
                result.add(resolutionRequest);
            }
            InputResolverUtil.ResolutionResult simpleResolutions = InputResolverUtil.multiResolve(result, VajramKryonGraph.getResolvers((ImmutableMap<ResolverDefinition, InputResolverDefinition>)ImmutableMap.copyOf((Map)resolversByResolverDefs), simpleResolverDefsByDep), (Inputs)inputs);
            @Nullable Map map = simpleResolutions.results();
            Map skippedDependencies = simpleResolutions.skippedDependencies();
            LinkedHashMap resolverCommands = new LinkedHashMap();
            for (ResolverDefinition resolverDefinition2 : complexResolverDefs) {
                DependencyCommand command2;
                String dependencyName = resolverDefinition2.dependencyName();
                if (skippedDependencies.containsKey(dependencyName)) continue;
                ImmutableSet resolvables = resolverDefinition2.resolvedInputNames();
                Object patt17562$temp = resolversByResolverDefs.get(resolverDefinition2);
                if (patt17562$temp instanceof InputResolver) {
                    InputResolver inputResolver = (InputResolver)patt17562$temp;
                    DependencyCommand command3 = inputResolver.resolve(dependencyName, resolvables, inputs);
                } else {
                    command2 = vajram.resolveInputOfDependency(dependencyName, resolvables, inputs);
                }
                if (command2.shouldSkip()) {
                    skippedDependencies.put(dependencyName, command2);
                    map.remove(dependencyName);
                    continue;
                }
                InputResolverUtil.collectDepInputs((List)map.computeIfAbsent(dependencyName, _k -> new ArrayList()), null, (DependencyCommand)command2);
            }
            map.forEach((key, value) -> resolverCommands.put(key, VajramKryonGraph.toResolverCommand(VajramKryonGraph.toDependencyCommand(value))));
            skippedDependencies.forEach((depName, command) -> resolverCommands.put(depName, ResolverCommand.skip((String)command.doc())));
            return ImmutableMap.copyOf(resolverCommands);
        });
        return new InputResolverCreationResult((ImmutableList<ResolverDefinition>)ImmutableList.copyOf(resolversByResolverDefs.keySet()), multiResolverDefinition.kryonLogicId());
    }

    private @UnknownKeyFor @NonNull @Initialized ResolverDefinition getResolverDefinition(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram, @UnknownKeyFor @NonNull @Initialized VajramID vajramId, @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized VajramInputDefinition> inputDefinitions, @UnknownKeyFor @NonNull @Initialized InputResolverDefinition inputResolverDefinition) {
        String dependencyName = inputResolverDefinition.resolutionTarget().dependencyName();
        ImmutableSet resolvedInputNames = inputResolverDefinition.resolutionTarget().inputNames();
        ImmutableSet sources = inputResolverDefinition.sources();
        ImmutableCollection requiredInputs = (ImmutableCollection)inputDefinitions.stream().filter(def -> sources.contains((Object)def.name())).collect(ImmutableList.toImmutableList());
        ResolverLogicDefinition inputResolverLogic = this.logicRegistryDecorator.newResolverLogic(vajramId.vajramId(), "%s:dep(%s):inputResolver(%s)".formatted(vajramId, dependencyName, String.join((CharSequence)",", (Iterable<? extends CharSequence>)resolvedInputNames)), (Set<String>)sources, inputValues -> {
            Object dependencyCommand;
            this.validateMandatory(vajramId, inputValues, (ImmutableCollection<VajramInputDefinition>)requiredInputs);
            try {
                if (inputResolverDefinition instanceof SimpleInputResolver) {
                    SimpleInputResolver inputResolver = (SimpleInputResolver)inputResolverDefinition;
                    InputResolverUtil.ResolutionResult resolutionResult = InputResolverUtil.multiResolve(List.of(new ResolutionRequest(dependencyName, resolvedInputNames)), (Map)ImmutableMap.of((Object)dependencyName, (Object)ImmutableList.of((Object)inputResolver)), (Inputs)inputValues);
                    dependencyCommand = resolutionResult.skippedDependencies().containsKey(dependencyName) ? (DependencyCommand)resolutionResult.skippedDependencies().get(dependencyName) : VajramKryonGraph.toDependencyCommand((List)resolutionResult.results().values().iterator().next());
                } else if (inputResolverDefinition instanceof InputResolver) {
                    InputResolver inputResolver = (InputResolver)inputResolverDefinition;
                    dependencyCommand = inputResolver.resolve(dependencyName, resolvedInputNames, inputValues);
                } else {
                    dependencyCommand = vajram.resolveInputOfDependency(dependencyName, resolvedInputNames, inputValues);
                }
            }
            catch (Throwable t) {
                dependencyCommand = SingleExecute.skipExecution((String)"Resolver threw exception: %s".formatted(Throwables.getStackTraceAsString((Throwable)t)));
            }
            return VajramKryonGraph.toResolverCommand(dependencyCommand);
        });
        return new ResolverDefinition(inputResolverLogic.kryonLogicId(), sources, dependencyName, resolvedInputNames);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SimpleInputResolver<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>>> getResolvers(@UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized ResolverDefinition, @UnknownKeyFor @NonNull @Initialized InputResolverDefinition> resolversByResolverDefs, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResolverDefinition>> simpleResolverDefsByDep) {
        HashMap resolverMap = new HashMap();
        simpleResolverDefsByDep.forEach((key, value) -> {
            ArrayList<SimpleInputResolver> list = new ArrayList<SimpleInputResolver>();
            for (ResolverDefinition def : value) {
                InputResolverDefinition ird = Optional.ofNullable((InputResolverDefinition)resolversByResolverDefs.get((Object)def)).orElseThrow(() -> new AssertionError((Object)"Could not find resolver for resolver definition. This should not happen"));
                SimpleInputResolver simpleInputResolver = (SimpleInputResolver)ird;
                list.add(simpleInputResolver);
            }
            resolverMap.put((String)key, (Collection<? extends SimpleInputResolver<?, ?, ?, ?>>)list);
        });
        return resolverMap;
    }

    private static @UnknownKeyFor @NonNull @Initialized ResolverCommand toResolverCommand(@UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Inputs> dependencyCommand) {
        if (dependencyCommand.shouldSkip()) {
            return ResolverCommand.skip((String)dependencyCommand.doc());
        }
        return ResolverCommand.multiExecuteWith(VajramKryonGraph.getCollectedInputs(dependencyCommand));
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Inputs> getCollectedInputs(@UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Inputs> dependencyCommand) {
        ArrayList<Inputs> inputsList = new ArrayList<Inputs>();
        dependencyCommand.inputs().forEach(input -> input.ifPresent(inputsList::add));
        return inputsList;
    }

    private void validateMandatory(@UnknownKeyFor @NonNull @Initialized VajramID vajramID, @UnknownKeyFor @NonNull @Initialized Inputs inputs, @UnknownKeyFor @NonNull @Initialized ImmutableCollection<@UnknownKeyFor @NonNull @Initialized VajramInputDefinition> requiredInputs) {
        ArrayList<VajramInputDefinition> mandatoryInputs = new ArrayList<VajramInputDefinition>();
        for (VajramInputDefinition vajramInputDefinition : mandatoryInputs) {
            if (!(vajramInputDefinition instanceof Input) || !vajramInputDefinition.isMandatory()) continue;
            mandatoryInputs.add(vajramInputDefinition);
        }
        HashMap<String, Throwable> missingMandatoryValues = new HashMap<String, Throwable>();
        for (VajramInputDefinition mandatoryInput : mandatoryInputs) {
            ValueOrError value = inputs.getInputValue(mandatoryInput.name());
            if (!value.error().isPresent() && !value.value().isEmpty()) continue;
            missingMandatoryValues.put(mandatoryInput.name(), value.error().orElse(new NoSuchElementException("No value present for input %s".formatted(mandatoryInput.name()))));
        }
        if (missingMandatoryValues.isEmpty()) {
            return;
        }
        throw new MandatoryInputsMissingException(vajramID, missingMandatoryValues);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MainLogicDefinition<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> createVajramKryonLogic(@UnknownKeyFor @NonNull @Initialized KryonId kryonId, @UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        VajramID vajramId = vajramDefinition.getVajram().getId();
        ImmutableCollection inputDefinitions = vajramDefinition.getVajram().getInputDefinitions();
        ImmutableSet inputNames = (ImmutableSet)inputDefinitions.stream().filter(this::isVisibleToKrystex).map(VajramInputDefinition::name).collect(ImmutableSet.toImmutableSet());
        KryonLogicId vajramLogicKryonName = new KryonLogicId(kryonId, "%s:vajramLogic".formatted(vajramId));
        MainLogicDefinition vajramLogic = this.logicRegistryDecorator.newMainLogic(vajramDefinition.getVajram() instanceof IOVajram, vajramLogicKryonName, (Set<String>)inputNames, inputsList -> {
            for (Inputs inputs : inputsList) {
                this.validateMandatory(vajramId, inputs, (ImmutableCollection<VajramInputDefinition>)inputDefinitions);
            }
            return vajramDefinition.getVajram().execute(inputsList);
        }, (ImmutableMap<String, Tag>)vajramDefinition.getMainLogicTags());
        this.registerInputInjector(vajramLogic, vajramDefinition.getVajram());
        for (MainLogicDecoratorConfig mainLogicDecoratorConfig : this.sessionScopedDecoratorConfigs.values()) {
            vajramLogic.registerSessionScopedLogicDecorator(mainLogicDecoratorConfig);
        }
        return vajramLogic;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isVisibleToKrystex(@UnknownKeyFor @NonNull @Initialized VajramInputDefinition vajramInputDefinition) {
        if (vajramInputDefinition instanceof Input) {
            Input input = (Input)vajramInputDefinition;
            return input.sources().contains((Object)InputSource.CLIENT);
        }
        return true;
    }

    private <T> void registerInputInjector(@UnknownKeyFor @NonNull @Initialized MainLogicDefinition<T> logicDefinition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Vajram<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> vajram) {
        logicDefinition.registerSessionScopedLogicDecorator(new MainLogicDecoratorConfig(InputInjector.DECORATOR_TYPE, logicExecutionContext -> {
            for (VajramInputDefinition inputDefinition : vajram.getInputDefinitions()) {
                Input input;
                if (!(inputDefinition instanceof Input) || (input = (Input)inputDefinition).sources() == null || !input.sources().contains((Object)InputSource.SESSION)) continue;
                return true;
            }
            return false;
        }, logicExecutionContext -> logicExecutionContext.kryonId().value(), decoratorContext -> this.inputInjector));
    }

    private static @UnknownKeyFor @NonNull @Initialized DependencyCommand<@UnknownKeyFor @NonNull @Initialized Inputs> toDependencyCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>> depInputs) {
        MultiExecute dependencyCommand;
        if (depInputs.isEmpty()) {
            dependencyCommand = MultiExecute.executeFanoutWith((Collection)ImmutableList.of());
        } else if (depInputs.size() == 1) {
            Map<String, InputValue> collect = depInputs.get(0).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ValueOrError.withValue(e.getValue())));
            dependencyCommand = SingleExecute.executeWith((Object)new Inputs(collect));
        } else {
            ArrayList<Inputs> inputsList = new ArrayList<Inputs>();
            for (Map<String, Object> depInput : depInputs) {
                inputsList.add(new Inputs(depInput.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ValueOrError.withValue(e.getValue())))));
            }
            dependencyCommand = MultiExecute.executeFanoutWith(inputsList);
        }
        return dependencyCommand;
    }

    private @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized KryonId> createKryonDefinitionsForDependencies(@UnknownKeyFor @NonNull @Initialized VajramDefinition vajramDefinition) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (VajramInputDefinition vajramInputDefinition : vajramDefinition.getVajram().getInputDefinitions()) {
            if (!(vajramInputDefinition instanceof Dependency)) continue;
            Dependency definition = (Dependency)vajramInputDefinition;
            dependencies.add(definition);
        }
        HashMap<String, KryonId> depNameToProviderKryon = new HashMap<String, KryonId>();
        for (Dependency dependency : dependencies) {
            DataAccessSpec accessSpec = dependency.dataAccessSpec();
            String dependencyName = dependency.name();
            AccessSpecMatchingResult accessSpecMatchingResult = this.vajramIndex.getVajrams(accessSpec);
            if (accessSpecMatchingResult.hasUnsuccessfulMatches()) {
                throw new VajramDefinitionException("Unable to find vajrams for accessSpecs %s".formatted(accessSpecMatchingResult.unsuccessfulMatches()));
            }
            ImmutableMap dependencyVajrams = accessSpecMatchingResult.successfulMatches();
            if (dependencyVajrams.size() > 1) {
                throw new UnsupportedOperationException("");
            }
            Vajram dependencyVajram = (Vajram)dependencyVajrams.values().iterator().next();
            depNameToProviderKryon.put(dependencyName, this._getVajramExecutionGraph(dependencyVajram.getId()));
        }
        return ImmutableMap.copyOf(depNameToProviderKryon);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized VajramDefinition> getVajramDefinition(@UnknownKeyFor @NonNull @Initialized VajramID vajramId) {
        return Optional.ofNullable(this.vajramDefinitions.get(vajramId));
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new Builder();
    }

    public @UnknownKeyFor @NonNull @Initialized KryonDefinitionRegistry getKryonDefinitionRegistry() {
        return this.kryonDefinitionRegistry;
    }

    private record InputResolverCreationResult(@UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized ResolverDefinition> resolverDefinitions, @UnknownKeyFor @NonNull @Initialized KryonLogicId multiResolver) {
    }

    public static final class Builder {
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> packagePrefixes = new LinkedHashSet<String>();
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig> sessionScopedDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
        private @UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering = new LogicDecorationOrdering(ImmutableSet.of());
        private @Nullable @UnknownKeyFor @Initialized InputInjectionProvider inputInjectionProvider;
        private @UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore = 1.0;

        public @UnknownKeyFor @NonNull @Initialized Builder loadFromPackage(@UnknownKeyFor @NonNull @Initialized String packagePrefix) {
            this.packagePrefixes.add(packagePrefix);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder decorateVajramLogicForSession(@UnknownKeyFor @NonNull @Initialized MainLogicDecoratorConfig logicDecoratorConfig) {
            if (this.sessionScopedDecoratorConfigs.putIfAbsent(logicDecoratorConfig.decoratorType(), logicDecoratorConfig) != null) {
                throw new IllegalArgumentException("Cannot have two decorator configs for same decorator type : %s".formatted(logicDecoratorConfig.decoratorType()));
            }
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder maxParallelismPerCore(@UnknownKeyFor @NonNull @Initialized double maxParallelismPerCore) {
            this.maxParallelismPerCore = maxParallelismPerCore;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder logicDecorationOrdering(@UnknownKeyFor @NonNull @Initialized LogicDecorationOrdering logicDecorationOrdering) {
            this.logicDecorationOrdering = logicDecorationOrdering;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder injectInputsWith(@UnknownKeyFor @NonNull @Initialized InputInjectionProvider inputInjectionProvider) {
            this.inputInjectionProvider = inputInjectionProvider;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized VajramKryonGraph build() {
            return new VajramKryonGraph((String[])this.packagePrefixes.toArray(String[]::new), (ImmutableMap<String, MainLogicDecoratorConfig>)ImmutableMap.copyOf(this.sessionScopedDecoratorConfigs), this.logicDecorationOrdering, this.inputInjectionProvider, this.maxParallelismPerCore);
        }
    }
}

