/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex.inputinjection;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.datatypes.JavaDataType;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.VajramID;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.inputs.Input;
import com.flipkart.krystal.vajram.inputs.InputSource;
import com.flipkart.krystal.vajram.inputs.VajramInputDefinition;
import com.flipkart.krystal.vajramexecutor.krystex.VajramNodeGraph;
import com.flipkart.krystal.vajramexecutor.krystex.inputinjection.InputInjectionProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Optional;

public final class InputInjector
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = InputInjector.class.getName();
    public static final String INJECT_NAMED_KEY = "inject.named";
    private VajramNodeGraph vajramNodeGraph;
    private final InputInjectionProvider inputInjectionProvider;

    public InputInjector(VajramNodeGraph vajramNodeGraph, InputInjectionProvider inputInjectionProvider) {
        this.vajramNodeGraph = vajramNodeGraph;
        this.inputInjectionProvider = inputInjectionProvider;
    }

    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate, MainLogicDefinition<Object> originalLogicDefinition) {
        return inputsList -> {
            HashMap newInputsToOldInputs = new HashMap();
            ImmutableList inputValues = (ImmutableList)inputsList.stream().map(inputs -> {
                Inputs newInputs = this.injectFromSession(this.vajramNodeGraph.getVajramDefinition(VajramID.vajramID((String)Optional.ofNullable(originalLogicDefinition.nodeLogicId()).map(NodeLogicId::nodeId).map(NodeId::value).orElse(""))).orElse(null), (Inputs)inputs);
                newInputsToOldInputs.put(newInputs, inputs);
                return newInputs;
            }).collect(ImmutableList.toImmutableList());
            ImmutableMap result = logicToDecorate.execute(inputValues);
            HashMap newResult = new HashMap();
            result.forEach((key, value) -> newResult.put(newInputsToOldInputs.getOrDefault(key, key), value));
            return ImmutableMap.copyOf(newResult);
        };
    }

    public String getId() {
        return InputInjector.class.getName();
    }

    private Inputs injectFromSession(VajramDefinition vajramDefinition, Inputs inputs) {
        HashMap newValues = new HashMap();
        Optional.ofNullable(vajramDefinition).map(VajramDefinition::getVajram).map(Vajram::getInputDefinitions).ifPresent(inputDefinitions -> {
            for (VajramInputDefinition inputDefinition : inputDefinitions) {
                ValueOrError<Object> value;
                String inputName = inputDefinition.name();
                if (!(inputDefinition instanceof Input)) continue;
                Input input = (Input)inputDefinition;
                if (input.sources().contains((Object)InputSource.CLIENT)) {
                    value = inputs.getInputValue(inputName);
                    if (!ValueOrError.empty().equals((Object)value)) continue;
                }
                if (!input.sources().contains((Object)InputSource.SESSION) || !(input.type() instanceof JavaDataType)) continue;
                value = this.getFromInjectionAdaptor((JavaDataType)input.type(), Optional.ofNullable(input.tags()).map(tags -> (Tag)tags.get((Object)INJECT_NAMED_KEY)).map(Tag::tagValue).orElse(null));
                newValues.put(inputName, value);
            }
        });
        if (!newValues.isEmpty()) {
            inputs.values().forEach(newValues::putIfAbsent);
            return new Inputs(newValues);
        }
        return inputs;
    }

    private ValueOrError<Object> getFromInjectionAdaptor(JavaDataType<?> dataType, String injectionName) {
        if (this.inputInjectionProvider == null) {
            return ValueOrError.withError((Throwable)new Exception("Dependency injector is null, cannot resolve SESSION input"));
        }
        if (dataType == null || dataType.javaType().isEmpty()) {
            return ValueOrError.withError((Throwable)new Exception("Data type not found"));
        }
        Optional type = dataType.javaType();
        Object resolvedObject = null;
        if (injectionName != null) {
            resolvedObject = this.inputInjectionProvider.getInstance((Class)type.get(), injectionName);
        }
        if (resolvedObject == null) {
            resolvedObject = this.inputInjectionProvider.getInstance((Class)type.get());
        }
        return ValueOrError.withValue(resolvedObject);
    }
}

