/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.Tag;
import com.flipkart.krystal.krystex.decoration.LogicExecutionContext;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.DefaultDependantChain;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.krystex.node.DependantChainFirstNode;
import com.flipkart.krystal.krystex.node.DependantChainStart;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.vajram.Vajram;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajramexecutor.krystex.InputModulationDecorator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public record InputModulatorConfig(Function<LogicExecutionContext, String> instanceIdGenerator, Predicate<LogicExecutionContext> shouldModulate, Function<ModulatorContext, MainLogicDecorator> decoratorFactory) {
    public static InputModulatorConfig simple(Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>> inputModulatorSupplier) {
        return new InputModulatorConfig(logicExecutionContext -> InputModulatorConfig.generateInstanceId(logicExecutionContext.dependants(), logicExecutionContext.nodeDefinitionRegistry()).toString(), _x -> true, modulatorContext -> {
            InputsConverter inputsConvertor = modulatorContext.vajram().getInputsConvertor();
            return new InputModulationDecorator(modulatorContext.decoratorContext().instanceId(), (InputModulator)inputModulatorSupplier.get(), inputsConvertor, dependantChain -> modulatorContext.decoratorContext().logicExecutionContext().dependants().equals(dependantChain));
        });
    }

    public static InputModulatorConfig sharedModulator(Supplier<InputModulator<InputValuesAdaptor, InputValuesAdaptor>> inputModulatorSupplier, String instanceId, Set<DependantChain> dependantChains) {
        return new InputModulatorConfig(logicExecutionContext -> instanceId, logicExecutionContext -> dependantChains.contains(logicExecutionContext.dependants()), modulatorContext -> {
            InputsConverter inputsConvertor = modulatorContext.vajram().getInputsConvertor();
            return new InputModulationDecorator(instanceId, (InputModulator)inputModulatorSupplier.get(), inputsConvertor, dependantChains::contains);
        });
    }

    private static StringBuilder generateInstanceId(DependantChain dependantChain, NodeDefinitionRegistry nodeDefinitionRegistry) {
        if (dependantChain instanceof DependantChainStart) {
            DependantChainStart dependantChainStart = (DependantChainStart)dependantChain;
            return new StringBuilder(dependantChainStart.asString());
        }
        if (dependantChain instanceof DependantChainFirstNode) {
            DependantChainFirstNode dependantChainFirstNode = (DependantChainFirstNode)dependantChain;
            String vajramId = Optional.ofNullable((Tag)nodeDefinitionRegistry.get(dependantChainFirstNode.nodeId()).getMainLogicDefinition().logicTags().get((Object)"vajram_id")).orElseThrow(() -> new NoSuchElementException("Could not find tag %s for node %s".formatted("vajram_id", dependantChainFirstNode.nodeId()))).tagValue();
            return InputModulatorConfig.generateInstanceId(dependantChainFirstNode.dependantChain(), nodeDefinitionRegistry).append('>').append(vajramId).append(':').append(dependantChainFirstNode.dependencyName());
        }
        if (dependantChain instanceof DefaultDependantChain) {
            DefaultDependantChain defaultDependantChain = (DefaultDependantChain)dependantChain;
            return InputModulatorConfig.generateInstanceId(defaultDependantChain.dependantChain(), nodeDefinitionRegistry).append('>').append(defaultDependantChain.dependencyName());
        }
        throw new UnsupportedOperationException();
    }

    public record ModulatorContext(Vajram<?> vajram, MainLogicDecoratorConfig.DecoratorContext decoratorContext) {
    }
}

