/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.vajramexecutor.krystex;

import com.flipkart.krystal.config.ConfigProvider;
import com.flipkart.krystal.config.NestedConfig;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.decoration.FlushCommand;
import com.flipkart.krystal.krystex.decoration.InitiateActiveDepChains;
import com.flipkart.krystal.krystex.decoration.LogicDecoratorCommand;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.DependantChain;
import com.flipkart.krystal.utils.Futures;
import com.flipkart.krystal.vajram.inputs.InputValuesAdaptor;
import com.flipkart.krystal.vajram.modulation.InputModulator;
import com.flipkart.krystal.vajram.modulation.InputsConverter;
import com.flipkart.krystal.vajram.modulation.ModulatedInput;
import com.flipkart.krystal.vajram.modulation.UnmodulatedInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;

public final class InputModulationDecorator<I extends InputValuesAdaptor, C extends InputValuesAdaptor>
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = InputModulationDecorator.class.getName();
    private final String instanceId;
    private final InputModulator<I, C> inputModulator;
    private final InputsConverter<I, C> inputsConverter;
    private final Predicate<DependantChain> isApplicableToDependantChain;
    private final Map<Inputs, CompletableFuture<Object>> futureCache = new HashMap<Inputs, CompletableFuture<Object>>();
    private ImmutableSet<DependantChain> activeDependantChains;
    private final Set<DependantChain> flushedDependantChains = new LinkedHashSet<DependantChain>();

    public InputModulationDecorator(String instanceId, InputModulator<I, C> inputModulator, InputsConverter<I, C> inputsConverter, Predicate<DependantChain> isApplicableToDependantChain) {
        this.instanceId = instanceId;
        this.inputModulator = inputModulator;
        this.inputsConverter = inputsConverter;
        this.isApplicableToDependantChain = isApplicableToDependantChain;
    }

    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate, MainLogicDefinition<Object> originalLogicDefinition) {
        this.inputModulator.onModulation(requests -> requests.forEach(request -> this.modulateInputsList(logicToDecorate, (ModulatedInput<I, C>)request)));
        return inputsList -> {
            List<C> requests = inputsList.stream().map(this.inputsConverter).toList();
            List modulatedInputs = requests.stream().map(unmodulatedInput -> this.inputModulator.add((Object)unmodulatedInput.inputsNeedingModulation(), (Object)unmodulatedInput.commonInputs())).flatMap(Collection::stream).toList();
            requests.forEach(request -> this.futureCache.computeIfAbsent(request.toInputValues(), e -> new CompletableFuture()));
            for (ModulatedInput modulatedInput : modulatedInputs) {
                this.modulateInputsList(logicToDecorate, modulatedInput);
            }
            return (ImmutableMap)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableMap.toImmutableMap(Function.identity(), this.futureCache::get));
        };
    }

    public void executeCommand(LogicDecoratorCommand logicDecoratorCommand) {
        if (logicDecoratorCommand instanceof InitiateActiveDepChains) {
            InitiateActiveDepChains initiateActiveDepChains = (InitiateActiveDepChains)logicDecoratorCommand;
            LinkedHashSet<DependantChain> allActiveDepChains = new LinkedHashSet<DependantChain>((Collection<DependantChain>)initiateActiveDepChains.dependantsChains());
            allActiveDepChains.removeIf(this.isApplicableToDependantChain.negate());
            this.activeDependantChains = ImmutableSet.copyOf(allActiveDepChains);
        } else if (logicDecoratorCommand instanceof FlushCommand) {
            FlushCommand flushCommand = (FlushCommand)logicDecoratorCommand;
            this.flushedDependantChains.add(flushCommand.dependantsChain());
            if (this.flushedDependantChains.containsAll((Collection<?>)this.activeDependantChains)) {
                this.inputModulator.modulate();
                this.flushedDependantChains.clear();
            }
        }
    }

    private void modulateInputsList(MainLogic<Object> logicToDecorate, ModulatedInput<I, C> modulatedInput) {
        ImmutableList requests = (ImmutableList)modulatedInput.inputsNeedingModulation().stream().map(each -> new UnmodulatedInput(each, (InputValuesAdaptor)modulatedInput.commonInputs())).collect(ImmutableList.toImmutableList());
        ImmutableMap originalFutures = logicToDecorate.execute((ImmutableList)requests.stream().map(UnmodulatedInput::toInputValues).collect(ImmutableList.toImmutableList()));
        originalFutures.forEach((inputs, resultFuture) -> {
            CompletableFuture cachedResult = this.futureCache.computeIfAbsent((Inputs)inputs, request -> new CompletableFuture());
            Futures.linkFutures((CompletableFuture)resultFuture, (CompletableFuture)cachedResult);
        });
    }

    public void onConfigUpdate(ConfigProvider configProvider) {
        this.inputModulator.onConfigUpdate((ConfigProvider)new NestedConfig("input_modulation.", configProvider));
    }

    public String getId() {
        return this.instanceId;
    }
}

